% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/op_interpolate.R
\name{op_interpolate}
\alias{op_interpolate}
\title{Interpolate missing or low-confidence values in a dataset}
\usage{
op_interpolate(
  data,
  confidence_threshold,
  missing = TRUE,
  treat_na_conf_as_low = FALSE
)
}
\arguments{
\item{data}{A data frame containing x, y, confidence columns, and grouping columns (\code{person}, \code{region}).}

\item{confidence_threshold}{A numeric value specifying the confidence threshold below which
values will be interpolated.}

\item{missing}{Logical. If TRUE, interpolate missing values (\code{NA}) in addition to low-confidence values.}

\item{treat_na_conf_as_low}{Logical. If TRUE, treat NA in the confidence column as low confidence.}
}
\value{
A modified data frame with interpolated x and y values for low-confidence or missing rows.
}
\description{
This function performs interpolation for x and y coordinate columns in a dataset
based on confidence thresholds. It groups the data by \code{person} and \code{region} and
uses spline interpolation to estimate missing or low-confidence values.
}
\examples{
# Load example data from the package
data_path <- system.file("extdata/csv_data/A-B_body_dyad.csv", package = "duet")
data <- read.csv(data_path)

# Interpolate missing or low-confidence values
result <- op_interpolate(
  data = data,
  confidence_threshold = 0.5,
  missing = TRUE,
  treat_na_conf_as_low = TRUE
)

print(result)
}
