% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddbs_geom_conversion.R
\name{ddbs_as_hexwkb}
\alias{ddbs_as_hexwkb}
\title{Convert geometries to hexadecimal Well-Known Binary (HEXWKB) format}
\usage{
ddbs_as_hexwkb(x, conn = NULL, quiet = FALSE)
}
\arguments{
\item{x}{An \code{sf} spatial object. Alternatively, it can be a string with the
name of a table with geometry column within the DuckDB database \code{conn}.
Data is returned from this object.}

\item{conn}{A connection object to a DuckDB database. If \code{NULL}, the function
runs on a temporary DuckDB database.}

\item{quiet}{A logical value. If \code{TRUE}, suppresses any informational messages.
Defaults to \code{FALSE}.}
}
\value{
A character vector containing hexadecimal-encoded WKB representations
of the geometries
}
\description{
Converts spatial geometries to their hexadecimal Well-Known Binary (HEXWKB)
representation. This function wraps DuckDB's ST_AsHEXWKB spatial function.
}
\details{
HEXWKB is a hexadecimal string representation of Well-Known Binary (WKB) format.
This encoding is human-readable (unlike raw WKB) while maintaining the compact
binary structure. HEXWKB is commonly used in databases and web services for
transmitting spatial data as text strings.
}
\examples{
\dontrun{
## load packages
library(duckspatial)
library(sf)

# create a duckdb database in memory (with spatial extension)
conn <- ddbs_create_conn(dbdir = "memory")

## read data
argentina_sf <- st_read(system.file("spatial/argentina.geojson", package = "duckspatial"))

## store in duckdb
ddbs_write_vector(conn, argentina_sf, "argentina")

## convert geometries to HEXWKB
hexwkb_text <- ddbs_as_hexwkb(conn = conn, "argentina")

## convert without using a connection
hexwkb_text <- ddbs_as_hexwkb(argentina_sf)
}
}
