% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_csv_duckdb.R
\name{read_csv_duckdb}
\alias{read_csv_duckdb}
\title{Read CSV files using DuckDB}
\usage{
read_csv_duckdb(
  path,
  ...,
  prudence = c("thrifty", "lavish", "stingy"),
  options = list()
)
}
\arguments{
\item{path}{Path to files, glob patterns \code{*} and \verb{?} are supported.}

\item{...}{These dots are for future extensions and must be empty.}

\item{prudence}{Memory protection, controls if DuckDB may convert
intermediate results in DuckDB-managed memory to data frames in R memory.
\itemize{
\item \code{"thrifty"}: up to a maximum size of 1 million cells,
\item \code{"lavish"}: regardless of size,
\item \code{"stingy"}: never.
}

The default is \code{"thrifty"} for the ingestion functions,
and may be different for other functions.
See \code{vignette("prudence")} for more information.}

\item{options}{Arguments to the DuckDB \code{read_csv_auto} table function.}
}
\description{
\code{read_csv_duckdb()} reads a CSV file using DuckDB's \code{read_csv_auto()} table function.
}
\examples{
# Create simple CSV file
path <- tempfile("duckplyr_test_", fileext = ".csv")
write.csv(data.frame(a = 1:3, b = letters[4:6]), path, row.names = FALSE)

# Reading is immediate
df <- read_csv_duckdb(path)

# Names are always available
names(df)

# Materialization upon access is turned off by default
try(print(df$a))

# Materialize explicitly
collect(df)$a

# Automatic materialization with prudence = "lavish"
df <- read_csv_duckdb(path, prudence = "lavish")
df$a

# Specify column types positionally
read_csv_duckdb(
  path,
  options = list(delim = ",", types = list(c("DOUBLE", "VARCHAR")))
)

# Specify column types by name
read_csv_duckdb(
  path,
  options = list(types = list(c(a = "DOUBLE", b = "VARCHAR")))
)
}
\seealso{
\code{\link[=read_parquet_duckdb]{read_parquet_duckdb()}}, \code{\link[=read_json_duckdb]{read_json_duckdb()}}
}
