% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_geo.R
\name{write_geo}
\alias{write_geo}
\title{Write a spatial file with gdal}
\usage{
write_geo(
  dataset,
  path,
  conn = cached_connection(),
  driver = "GeoJSON",
  layer_creation_options = "WRITE_BBOX=YES",
  srs = "ESPG:4326"
)
}
\arguments{
\item{dataset}{a remote tbl object from \code{open_dataset},
or an in-memory data.frame.}

\item{path}{a local file path or S3 path with write credentials}

\item{conn}{duckdbfs database connection}

\item{driver}{driver, see \url{https://duckdb.org/docs/stable/extensions/spatial/gdal}}

\item{layer_creation_options}{to GDAL, see \url{https://duckdb.org/docs/stable/extensions/spatial/gdal}}

\item{srs}{Set a spatial reference system as metadata to use for the export.
This can be a WKT string, an EPSG code or a proj-string, basically anything
you would normally be able to pass to GDAL. Note that this will not perform
any reprojection of the input geometry, it just sets the metadata if the
target driver supports it.}
}
\description{
Write a spatial file with gdal
}
\details{
NOTE: at this time, duckdb's pre-packaged GDAL does not support s3 writes,
and will produce a "Error: Not implemented Error: GDAL Error (6): Seek not supported on writable /vsis3/ files".
Use to_geojson() to export using duckdb's native JSON serializer instead.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
local_file <-  system.file("extdata/spatial-test.csv", package="duckdbfs")
load_spatial()
tbl <- open_dataset(local_file, format='csv')
write_geo(tbl, "spatial.geojson")
\dontshow{\}) # examplesIf}
}
