% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dua.R
\name{see_dua_level}
\alias{see_dua_level}
\title{Show current DUA restriction level setting}
\usage{
see_dua_level(show_restrictions = FALSE, sort_vars = TRUE, ...)
}
\arguments{
\item{show_restrictions}{Show the names of the variables that are
restricted by the current level if \code{TRUE}.}

\item{sort_vars}{Sort variables alphabetically when printing
restrictions; if \code{FALSE}, prints in the order saved in the
crosswalk file}

\item{...}{For debugging.}
}
\description{
After setting the DUA restriction level, check the setting and
restricted data elements.
}
\examples{
## --------------
## Setup
## --------------
## set DUA crosswalk
dua_cw <- system.file('extdata', 'dua_cw.csv', package = 'duawranglr')
set_dua_cw(dua_cw)
## --------------

## set restriction level
set_dua_level('level_i')

## show name of current restriction level
see_dua_level()

## ...include names of restricted elements
see_dua_level(show_restrictions = TRUE)

## ...show variable names in order saved in crosswalk file
see_dua_level(show_restrictions = TRUE, sort_vars = FALSE)

}
