% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddstable1.R
\name{ddstable}
\alias{ddstable}
\title{The discrete stable distribution: formulae for the probabilities (density)}
\usage{
ddstable(x, alpha, lambda)
}
\arguments{
\item{x}{a vector of non-negative integer quantiles, \code{k>=0}}

\item{alpha}{tail index parameter \code{alpha} in the interval= \eqn{(0, 1]}}

\item{lambda}{positive location parameter \code{lambda>0}}
}
\value{
Returns the value of the formulae for the probabilities (density) of \code{DS(alpha,lambda)}.
}
\description{
Computes the value of the formulae for the probabilities (density) of a discrete stable distribution \code{DS(alpha,lambda)}, by combining the explicit and fast asymptotic formulae.
}
\examples{
ddstable(c(0,1,2,100),1,lambda=1)#This is Poisson with lambda=1
dpois(c(0,1,2,100),1)#Checking with dpois
ddstable(c(0,1,2,100),0.5,lambda=1) # tail is heavier
ddstable(c(0,1,2,3,6,100),0.5,lambda=3) # change in location
}
\references{
\insertRef{CHRISTOPH1998243}{dstabledist}
}
