% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ASV.R
\name{fit_ASV}
\alias{fit_ASV}
\title{MCMC Sampler for Adaptive Stchoastic Volatility (ASV) model}
\usage{
fit_ASV(
  y,
  beta = 0,
  evol_error = "DHS",
  D = 1,
  nsave = 1000,
  nburn = 1000,
  nskip = 4,
  mcmc_params = list("h", "logy2hat", "sigma2", "evol_sigma_t2", "dhs_phi", "dhs_mean"),
  nugget = FALSE,
  computeDIC = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{y}{the \code{T x 1} vector of time series observations.}

\item{beta}{the mean of the observed process y. If not provided, they are assumed to be 0.}

\item{evol_error}{the evolution error distribution; must be one of
'DHS' (dynamic horseshoe prior), 'HS' (horseshoe prior), 'BL' (Bayesian lasso), or 'NIG' (normal-inverse-gamma prior)}

\item{D}{degree of differencing (D = 1, or D = 2)}

\item{nsave}{number of MCMC iterations to record}

\item{nburn}{number of MCMC iterations to discard (burin-in)}

\item{nskip}{number of MCMC iterations to skip between saving iterations,
i.e., save every (nskip + 1)th draw}

\item{mcmc_params}{named list of parameters for which we store the MCMC output;
must be one or more of:
\itemize{
\item "h" (Log variance)
\item "h_smooth" (smooth estimate of log variances. Only used when \code{nugget_asv = TRUE})
\item "logy2hat" (posterior predictive distribution of log(y^2))
\item "sigma2" (Variance, i.e. exp(h))
\item "evol_sigma_t2" (evolution error variance)
\item "dhs_phi" (DHS AR(1) coefficient)
\item "dhs_mean" (DHS AR(1) unconditional mean)
}}

\item{nugget}{logical; if \code{TRUE}, fits the nugget variant of the ASV model}

\item{computeDIC}{logical; if TRUE, compute the deviance information criterion \code{DIC}
and the effective number of parameters \code{p_d}}

\item{verbose}{logical; should R report extra information on progress?}
}
\value{
A named list of the \code{nsave} MCMC samples for the parameters named in \code{mcmc_params}
}
\description{
The penalty is determined by the prior on the evolution errors, which include:
\itemize{
\item the dynamic horseshoe prior ('DHS');
\item the static horseshoe prior ('HS');
\item the Bayesian lasso ('BL');
\item the normal-inverse-gamma prior ('NIG').
}
In each case, the evolution error is a scale mixture of Gaussians.
Sampling is accomplished with a (parameter-expanded) Gibbs sampler,
mostly relying on a dynamic linear model representation.
}
\note{
The data \code{y} may contain NAs, which will be treated with a simple imputation scheme
via an additional Gibbs sampling step. In general, rescaling \code{y} to have unit standard
deviation is recommended to avoid numerical issues.
}
