% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayes-factor.R
\name{as_pvalue}
\alias{as_pvalue}
\title{Convert Bayes Factor to P-value}
\usage{
as_pvalue(bf)
}
\arguments{
\item{bf}{Bayes factor.}
}
\value{
p-value (scalar value).
}
\description{
Convert Bayes Factor to P-value
}
\examples{
\donttest{
library(dsos)
pvalue_from_bf <- as_pvalue(bf = 1)
pvalue_from_bf
}

}
\references{
Marsman, M., & Wagenmakers, E. J. (2017).
\emph{Three insights from a Bayesian interpretation of the one-sided P value}.
Educational and Psychological Measurement, 77(3), 529-539.
}
\seealso{
[as_bf()] to convert p-value to Bayes factor.

Other bayesian-test: 
\code{\link{as_bf}()},
\code{\link{bf_compare}()},
\code{\link{bf_from_os}()}
}
\concept{bayesian-test}
