% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xtsplot.R
\name{xtsplot}
\alias{xtsplot}
\title{Create a plot for xts series}
\usage{
xtsplot(
  xts,
  transform = "none",
  type = "line",
  years = NA,
  scale = 1,
  names = NA,
  color = NA,
  main = "",
  legend = NA,
  textsize = 1,
  textsize_x = NA,
  textsize_y = NA,
  textsize_legend = NA,
  textsize_title = NA,
  linesize = 1.1,
  WeekOfYear = F,
  date_breaks = NA,
  date_labels = NA,
  submain = NULL
)
}
\arguments{
\item{xts}{one or many series}

\item{transform}{one of "none","diff", "change" (can be abbreviated)}

\item{type}{either "bar", "bar2" or "line"}

\item{years}{number of years to include}

\item{scale}{by what factor should data be scaled.}

\item{names}{change names of series}

\item{color}{color of the series}

\item{main}{title of the plot}

\item{legend}{alignment of legend. "horizontal" or "vertical"}

\item{textsize}{scale the size of all the text}

\item{textsize_x}{scale size of x-axis labels}

\item{textsize_y}{scale size of y-axis labels}

\item{textsize_legend}{scale size of legend text}

\item{textsize_title}{scale size of title}

\item{linesize}{scale the size of the lines}

\item{WeekOfYear}{should x axis be week of year}

\item{date_breaks}{distance between labels (see examples)}

\item{date_labels}{format of the date label for x-axis}

\item{submain}{subtitle of the plot}
}
\description{
Creates a plot using an xts series
}
\details{
This function uses the ggplot2 package.
The difference between type="bar" and type="bar2" is that the former produces barcharts with bars of the second series in front of the bars of the first series (and accordingly for more than two series), while "bar2" creates side-by-side barcharts.
If a scale is supplied, the data will be divided by this number.
}
\examples{
x <- xts::xts(rnorm(100), seq.Date(as.Date("2010-01-01"), length.out=100, by="months"))
y <- xts::xts(runif(100), seq.Date(as.Date("2010-01-01"), length.out=100, by="months"))
xtsplot(y, transform="diff", type="bar")
xtsplot(y, transform="diff", type="bar", date_breaks="24 months")
xtsplot(merge(x,y), names=c("Gaussian", "Uniform"), main="Simulated series")
}
\author{
Daniel Ollech
}
