% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds.boxPlot.R
\name{ds.boxPlot}
\alias{ds.boxPlot}
\title{Draw boxplot}
\usage{
ds.boxPlot(
  x,
  variables = NULL,
  group = NULL,
  group2 = NULL,
  xlabel = "x axis",
  ylabel = "y axis",
  type = "pooled",
  datasources = NULL
)
}
\arguments{
\item{x}{\code{character} Name of the data frame (or numeric vector) on the server side that
holds the information to be plotted}

\item{variables}{\code{character vector} Name of the column(s) of the data frame to include on the boxplot}

\item{group}{\code{character} (default \code{NULL}) Name of the first grouping variable.}

\item{group2}{\code{character} (default \code{NULL}) Name of the second grouping variable.}

\item{xlabel}{\code{caracter} (default \code{"x axis"}) Label to put on the x axis of the plot}

\item{ylabel}{\code{caracter} (default \code{"y axis"}) Label to put on the y axis of the plot}

\item{type}{\code{character} Return a pooled plot (\code{"pooled"}) or a split plot (one for each study server
\code{"split"})}

\item{datasources}{a list of \code{\link[DSI]{DSConnection-class}} (default \code{NULL}) objects obtained after login}
}
\value{
\code{ggplot} object
}
\description{
Draw boxplot with data on the study servers (data frames or numeric vectors) with the option
of grouping using categorical variables on the dataset (only for data frames)
}
\examples{
\dontrun{
  ## Version 6, for version 5 see the Wiki
  
  ### Please ensure you have a training Virtual Machine running,
  # or that you have a live connection to a server.
     
  # Connecting to the Opal servers

  require('DSI')
  require('DSOpal')
  require('dsBaseClient')

  builder <- DSI::newDSLoginBuilder()
  builder$append(server = "study1", 
                 url = "http://192.168.56.100:8080/", 
                 user = "administrator", password = "datashield_test&", 
                 table = "CNSIM.CNSIM1", driver = "OpalDriver")
  builder$append(server = "study2", 
                 url = "http://192.168.56.100:8080/", 
                 user = "administrator", password = "datashield_test&", 
                 table = "CNSIM.CNSIM2", driver = "OpalDriver")
  builder$append(server = "study3",
                 url = "http://192.168.56.100:8080/", 
                 user = "administrator", password = "datashield_test&", 
                 table = "CNSIM.CNSIM3", driver = "OpalDriver")
  logindata <- builder$build()
  
  connections <- DSI::datashield.login(logins = logindata, assign = TRUE,
   symbol = "D") 
  
  ## Create a boxplot of one variable
  ds.boxPlot("D", "LAB_HDL", datasources = connections)
 
  ## Create a boxplot that is split by study:
  ds.boxPlot("D", "LAB_HDL", type= "split", datasources = connections)
  
  ## Create a boxplot of two variables variable
  ds.boxPlot("D", c("LAB_HDL", "LAB_TRIG"), type="pooled",
  datasources = connections)
  # only one plot is created (of the aggregated results of all servers)
  
  ## Create a boxplot of two variables, which are split by a factor
  ds.boxPlot("D", c("LAB_HDL", "LAB_TRIG"), group = "GENDER",
  datasources = connections)
  
  ## Create a boxplot with x- and y-axis labels
  ds.boxPlot("D", c("LAB_HDL", "LAB_TRIG"), group = "GENDER",
  xlabel = "Variable", ylabel = "Measurement", datasources = connections)
  
  ## Improve the presentation of ds.boxplot output using ggplot:
  ### User must save the output, which is in a ggplot format already:
  a <- ds.boxPlot("D", c("LAB_HDL", "LAB_TRIG"), group = "GENDER",
  xlabel = "Variable", ylabel = "Measurement", datasources = connections)
                 
  ### Then customise output "a" using ggplot tools:
  a + ggplot2::scale_fill_discrete(name = "Gender", labels = c("Male", "Female"))
  
  ### Or use an alternative way, to maintain the aesthetics:
  a + ggplot2::scale_fill_brewer(name = "Gender", labels = c("Male", "Female"))
                                                                                
  # Clear the Datashield R sessions and logout                 
  datashield.logout(connections)
  
}   

}
