% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_fun.R
\name{sample_time}
\alias{sample_time}
\title{Draw a sample of n random times (from a given range).}
\usage{
sample_time(
  from = "1970-01-01 00:00:00",
  to = Sys.time(),
  size = 1,
  as_POSIXct = TRUE,
  tz = "",
  ...
)
}
\arguments{
\item{from}{Earliest date-time (as string). 
Default: \code{from = "1970-01-01 00:00:00"} 
(as a scalar).}

\item{to}{Latest date-time (as string). 
Default: \code{to = Sys.time()} 
(as a scalar).}

\item{size}{Size of time samples to draw. 
Default: \code{size = 1}.}

\item{as_POSIXct}{Boolean: Return calendar time ("POSIXct") object? 
Default: \code{as_POSIXct = TRUE}. 
If \code{as_POSIXct = FALSE}, a local time ("POSIXlt") object is returned 
(as a list).}

\item{tz}{Time zone.
Default: \code{tz = ""} (i.e., current system time zone,  
see \code{Sys.timezone()}). 
Use \code{tz = "UTC"} for Universal Time, Coordinated.}

\item{...}{Other arguments.
(Use for specifying \code{replace}, as passed to \code{sample()}.)}
}
\value{
A vector of class "POSIXct" or "POSIXlt".
}
\description{
\code{sample_time} draws a sample of  
\code{n} random times from a given range.
}
\details{
By default, \code{sample_time} draws \code{n = 1} 
random calendar time (as a "POSIXct" object) in the range 
\code{from = "1970-01-01 00:00:00"} 
\code{to = Sys.time()} (current time).

Both \code{from} and \code{to} currently 
need to be scalars (i.e., with a length of 1). 

If \code{as_POSIXct = FALSE}, a local time ("POSIXlt") object is returned 
(as a list). 

The \code{tz} argument allows specifying time zones 
(see \code{Sys.timezone()} for current setting 
and \code{OlsonNames()} for options.)
}
\examples{
# Basics:
sample_time()
sample_time(size = 10)

# Specific ranges:
sort(sample_time(from = (Sys.time() - 60), size = 10))  # within last minute
sort(sample_time(from = (Sys.time() - 1 * 60 * 60), size = 10))  # within last hour
sort(sample_time(from = Sys.time(), to = (Sys.time() + 1 * 60 * 60), 
     size = 10, replace = FALSE))  # within next hour
sort(sample_time(from = "2020-12-31 00:00:00 CET", to = "2020-12-31 00:00:01 CET",
                 size = 10, replace = TRUE))  # within 1 sec range 
                           
# Local time (POSIXlt) objects (as list):
(lt_sample <- sample_time(as_POSIXct = FALSE))
unlist(lt_sample)

# Time zones:
sample_time(size = 3, tz = "UTC")
sample_time(size = 3, tz = "America/Los_Angeles")
 
# Note: Oddity with sample(): 
sort(sample_time(from = "2020-12-31 00:00:00 CET", to = "2020-12-31 00:00:00 CET",
     size = 10, replace = TRUE))  # range of 0!
# see sample(9:9, size = 10, replace = TRUE)

}
\seealso{
Other sampling functions: 
\code{\link{coin}()},
\code{\link{dice}()},
\code{\link{dice_2}()},
\code{\link{sample_char}()},
\code{\link{sample_date}()}
}
\concept{sampling functions}
