% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_fun.R
\name{change_tz}
\alias{change_tz}
\title{Change time zone (without changing represented time).}
\usage{
change_tz(time, tz = "")
}
\arguments{
\item{time}{Time (as a scalar or vector).
If \code{time} is not a calendar time (of the "POSIXct" class) 
the function first tries coercing \code{time} into "POSIXct" 
without changing the denoted time.}

\item{tz}{Time zone (as character string).
Default: \code{tz = ""} 
(i.e., current system time zone, \code{Sys.timezone()}). 
See \code{OlsonNames()} for valid options.}
}
\value{
A local time of class "POSIXlt".
}
\description{
\code{change_tz} changes the nominal time zone (i.e., the time display) 
without changing the actual time.
}
\details{
\code{change_tz} expects inputs to \code{time} 
to be calendar time(s) (of the "POSIXct" class) 
and a valid time zone argument \code{tz} (as a string)
and returns the same time(s) as local time(s) 
(of the "POSIXlt" class).
}
\examples{
change_tz(Sys.time(), tz = "Pacific/Auckland")
change_tz(Sys.time(), tz = "Pacific/Honolulu")

# from "POSIXct" time:
tc <- as.POSIXct("2020-07-01 12:00:00", tz = "UTC")
change_tz(tc, "Australia/Melbourne")
change_tz(tc, "Europe/Berlin")
change_tz(tc, "America/Los_Angeles")

# from "POSIXlt" time:
tl <- as.POSIXlt("2020-07-01 12:00:00", tz = "UTC")
change_tz(tl, "Australia/Melbourne")
change_tz(tl, "Europe/Berlin")
change_tz(tl, "America/Los_Angeles")

# from "Date":
dt <- as.Date("2020-12-31")
change_tz(dt, "Pacific/Auckland")
change_tz(dt, "Pacific/Honolulu")  # Note different date!

# with a vector of "POSIXct" times:
t2 <- as.POSIXct("2020-12-31 23:59:55", tz = "America/Los_Angeles")
tv <- c(tc, t2)
tv  # Note: Both times in tz of tc
change_tz(tv, "America/Los_Angeles")

}
\seealso{
\code{\link{change_time}} function which preserves time display but changes time; 
\code{Sys.time()} function of \strong{base} R.

Other date and time functions: 
\code{\link{change_time}()},
\code{\link{cur_date}()},
\code{\link{cur_time}()},
\code{\link{days_in_month}()},
\code{\link{diff_dates}()},
\code{\link{diff_times}()},
\code{\link{diff_tz}()},
\code{\link{is_leap_year}()},
\code{\link{what_date}()},
\code{\link{what_month}()},
\code{\link{what_time}()},
\code{\link{what_wday}()},
\code{\link{what_week}()},
\code{\link{what_year}()},
\code{\link{zodiac}()}
}
\concept{date and time functions}
