% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_multiarm.R
\name{utility_multiarm}
\alias{utility_multiarm}
\title{Utility function for multiarm programs with time-to-event outcomes}
\usage{
utility_multiarm(
  n2,
  HRgo,
  alpha,
  beta,
  hr1,
  hr2,
  strategy,
  ec,
  c2,
  c02,
  c3,
  c03,
  K,
  N,
  S,
  steps1,
  stepm1,
  stepl1,
  b1,
  b2,
  b3
)
}
\arguments{
\item{n2}{total sample size for phase II; must be divisible by three}

\item{HRgo}{threshold value for the go/no-go decision rule}

\item{alpha}{significance level}

\item{beta}{1-beta power for calculation of sample size for phase III}

\item{hr1}{assumed true treatment effect on HR scale for treatment 1}

\item{hr2}{assumed true treatment effect on HR scale for treatment 2}

\item{strategy}{choose Strategy: 1 ("only best promising"), 2 ("all promising")}

\item{ec}{control arm event rate for phase II and III}

\item{c2}{variable per-patient cost for phase II}

\item{c02}{fixed cost for phase II}

\item{c3}{variable per-patient cost for phase III}

\item{c03}{fixed cost for phase III}

\item{K}{constraint on the costs of the program, default: Inf, e.g. no constraint}

\item{N}{constraint on the total expected sample size of the program, default: Inf, e.g. no constraint}

\item{S}{constraint on the expected probability of a successful program, default: -Inf, e.g. no constraint}

\item{steps1}{lower boundary for effect size category \code{"small"} in HR scale, default: 1}

\item{stepm1}{lower boundary for effect size category \code{"medium"} in HR scale = upper boundary for effect size category "small" in RR scale, default: 0.95}

\item{stepl1}{lower boundary for effect size category \code{"large"} in HR scale = upper boundary for effect size category "medium" in RR scale, default: 0.85}

\item{b1}{expected gain for effect size category \code{"small"}}

\item{b2}{expected gain for effect size category \code{"medium"}}

\item{b3}{expected gain for effect size category \code{"large"}}
}
\value{
The output of the function \code{utility_multiarm()} is the expected utility of the program
}
\description{
The utility function calculates the expected utility of our drug development program and is given as gains minus costs and depends on the parameters as on the sample size and expected probability of a successful program.
The utility is in further step maximized by the \code{optimal_multiarm()} function.
}
\examples{
\donttest{utility_multiarm(n2 = 50, HRgo = 0.8, alpha = 0.05, beta = 0.1,
                            hr1 = 0.7, hr2 = 0.8, strategy = 2, ec = 0.6,
                            c2 = 0.75, c3 = 1, c02 = 100, c03 = 150,
                            K = Inf, N = Inf, S = -Inf,  
                            steps1 = 1, stepm1 = 0.95,  stepl1 = 0.85,
                            b1 = 1000, b2 = 2000, b3 = 3000)}
}
\keyword{internal}
