% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimal_multiarm_normal.R
\name{optimal_multiarm_normal}
\alias{optimal_multiarm_normal}
\title{Optimal phase II/III drug development planning for multi-arm programs with
normally distributed endpoint}
\usage{
optimal_multiarm_normal(
  Delta1,
  Delta2,
  n2min,
  n2max,
  stepn2,
  kappamin,
  kappamax,
  stepkappa,
  alpha,
  beta,
  c2,
  c3,
  c02,
  c03,
  K = Inf,
  N = Inf,
  S = -Inf,
  steps1 = 0,
  stepm1 = 0.5,
  stepl1 = 0.8,
  b1,
  b2,
  b3,
  strategy,
  num_cl = 1
)
}
\arguments{
\item{Delta1}{assumed true treatment effect as the standardized difference in
means for treatment arm 1}

\item{Delta2}{assumed true treatment effect as the standardized difference in
means for treatment arm 2}

\item{n2min}{minimal total sample size in phase II, must be divisible by 3}

\item{n2max}{maximal total sample size in phase II, must be divisible by 3}

\item{stepn2}{stepsize for the optimization over n2, must be divisible by 3}

\item{kappamin}{minimal threshold value kappa for the go/no-go decision rule}

\item{kappamax}{maximal threshold value  kappa for the go/no-go decision rule}

\item{stepkappa}{step size for the optimization over the threshold value kappa}

\item{alpha}{one-sided significance level/family-wise error rate}

\item{beta}{type-II error rate for any pair, i.e. \code{1 - beta} is the (any-pair) power for calculation of the sample size for phase III}

\item{c2}{variable per-patient cost for phase II}

\item{c3}{variable per-patient cost for phase III}

\item{c02}{fixed cost for phase II}

\item{c03}{fixed cost for phase III}

\item{K}{constraint on the costs of the program, default: \code{Inf}, e.g. no constraint}

\item{N}{constraint on the total expected sample size of the program, default: \code{Inf}, e.g. no constraint}

\item{S}{constraint on the expected probability of a successful program, default: \code{-Inf}, e.g. no constraint}

\item{steps1}{lower boundary for effect size category "small", default: 0}

\item{stepm1}{lower boundary for effect size category "medium" = upper boundary for effect size category "small" default: 0.5}

\item{stepl1}{lower boundary for effect size category "large" = upper boundary for effect size category "medium", default: 0.8}

\item{b1}{expected gain for effect size category "small"}

\item{b2}{expected gain for effect size category "medium"}

\item{b3}{expected gain for effect size category "large"}

\item{strategy}{choose strategy: 1 (only the best promising candidate), 2 (all promising candidates) or 3 (both strategies)}

\item{num_cl}{number of clusters used for parallel computing, default: 1}
}
\value{
The output of the function is a \code{data.frame} object containing the optimization results:
\describe{\item{Strategy}{Strategy, 1: "only best promising" or 2: "all promising"}\item{u}{maximal expected utility under the optimization constraints, i.e. the expected utility of the optimal sample size and threshold value}\item{Kappa}{optimal threshold value for the decision rule to go to phase III}\item{n2}{total sample size for phase II; rounded to the next even natural number}
\item{n3}{total sample size for phase III; rounded to the next even natural number}
\item{n}{total sample size in the program; n = n2 + n3}
\item{K}{maximal costs of the program (i.e. the cost constraint, if it is set or the sum K2+K3 if no cost constraint is set)}
\item{pgo}{probability to go to phase III}
\item{sProg}{probability of a successful program}\item{sProg2}{probability of a successful program with two arms in phase III}
\item{sProg3}{probability of a successful program with three arms in phase III}\item{K2}{expected costs for phase II}
\item{K3}{expected costs for phase III}}
and further input parameters. Taking \code{cat(comment())} of the
data frame lists the used optimization sequences, start and
finish time of the optimization procedure. The attribute
\code{attr(,"trace")} returns the utility values of all parameter
combinations visited during optimization.
}
\description{
The \code{\link{optimal_multiarm_normal}} function enables planning of
multi-arm phase II/III drug development programs with optimal sample size
allocation and go/no-go decision rules. For normally distributed endpoints,
the treatment effect is measured by the standardized difference in means
(Delta). So far, only three-arm trials with two treatments and one control
are supported. The assumed true treatment effects can be assumed fixed or
modelled by a prior distribution. The R Shiny application
\href{https://web.imbi.uni-heidelberg.de/prior/}{prior} visualizes the
prior distributions used in this package. Fast computing is enabled by
parallel programming.
}
\examples{
# Activate progress bar (optional)
\dontrun{progressr::handlers(global = TRUE)}
# Optimize
\donttest{
optimal_multiarm_normal(Delta1 = 0.375, Delta2 = 0.625,     
  n2min = 20, n2max = 100, stepn2 = 4,                 # define optimization set for n2
  kappamin = 0.02, kappamax = 0.2, stepkappa = 0.02,   # define optimization set for kappa
  alpha = 0.025, beta = 0.1,                           # drug development planning parameters
  c2 = 0.675, c3 = 0.72, c02 = 15, c03 = 20,           # fixed/variable costs for phase II/III
  K = Inf, N = Inf, S = -Inf,                          # set constraints
  steps1 = 0,                                          # define lower boundary for "small"
  stepm1 = 0.5,                                        # "medium"
  stepl1 = 0.8,                                        # and "large" effect size categories
  b1 = 3000, b2 = 8000, b3 = 10000,                    # define expected benefits 
  strategy = 1,
  num_cl = 1)                                          # number of cores for parallelized computing 
  }
}
\references{
Cohen, J. (1988). Statistical power analysis for the behavioral sciences.
}
