% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_multiple_normal.R
\name{EPsProg_multiple_normal}
\alias{EPsProg_multiple_normal}
\title{Expected probability of a successful program for multiple endpoints and normally distributed outcomes}
\usage{
EPsProg_multiple_normal(
  kappa,
  n2,
  alpha,
  beta,
  Delta1,
  Delta2,
  sigma1,
  sigma2,
  step11,
  step12,
  step21,
  step22,
  in1,
  in2,
  fixed,
  rho,
  rsamp
)
}
\arguments{
\item{kappa}{threshold value for the go/no-go decision rule;}

\item{n2}{total sample size for phase II; must be even number}

\item{alpha}{significance level}

\item{beta}{\code{1-beta} power for calculation of sample size for phase III}

\item{Delta1}{assumed true treatment effect given as difference in means for endpoint 1}

\item{Delta2}{assumed true treatment effect given as difference in means for endpoint 2}

\item{sigma1}{standard deviation of first endpoint}

\item{sigma2}{standard deviation of second endpoint}

\item{step11}{lower boundary for effect size for first endpoint}

\item{step12}{lower boundary for effect size for second endpoint}

\item{step21}{upper boundary for effect size for first endpoint}

\item{step22}{upper boundary for effect size for second endpoint}

\item{in1}{amount of information for \code{Delta1} in terms of sample size}

\item{in2}{amount of information for \code{Delta2} in terms of sample size}

\item{fixed}{choose if true treatment effects are fixed or random, if TRUE then \code{Delta1} is used as fixed effect}

\item{rho}{correlation between the two endpoints}

\item{rsamp}{sample data set for Monte Carlo integration}
}
\value{
The output of the function \code{EPsProg_multiple_normal()} is the expected probability of a successfull program, when going to phase III.
}
\description{
This function calculates the probability that our drug development program is successful.
Successful is defined as both endpoints showing a statistically significant positive treatment effect in phase III.
}
\keyword{internal}
