% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FuncDGP.R
\name{FuncDGP}
\alias{FuncDGP}
\title{Generate Data for LATE}
\usage{
FuncDGP(dgptype, rndflag, n, g, pi)
}
\arguments{
\item{dgptype}{A Scalar. 1, 2, 3 (See Jiang et al. (2022) for DGP details)}

\item{rndflag}{A Scalar. Declare the method of covariate-adaptive randomization. 1-SRS; 2-WEI; 3-BCD; 4-SBR.}

\item{n}{Sample size}

\item{g}{Number of strata. The authors set g=4 in the Jiang et al. (2022).}

\item{pi}{Targeted assignment probability across strata.}
}
\value{
FuncDGP returns a list containing 9 nx1 vectors named Y, X, S, A, Y1, Y0, D1, D0 and D.
   These nine vectors are the same as defined in Jiang et al. (2022).
   Note that vector X does not contain the constant term.
}
\description{
Generate data according to one of the three DGPs in Jiang et al. (2022).
}
\examples{
FuncDGP(dgptype = 1, rndflag = 1, n = 200, g = 4, pi = c(0.5,0.5,0.5,0.5))
FuncDGP(dgptype = 1, rndflag = 2, n = 200, g = 4, pi = c(0.5,0.5,0.5,0.5))
FuncDGP(dgptype = 1, rndflag = 3, n = 200, g = 4, pi = c(0.5,0.5,0.5,0.5))
FuncDGP(dgptype = 1, rndflag = 4, n = 200, g = 4, pi = c(0.5,0.5,0.5,0.5))

FuncDGP(dgptype = 2, rndflag = 1, n = 200, g = 4, pi = c(0.5,0.5,0.5,0.5))
FuncDGP(dgptype = 2, rndflag = 2, n = 200, g = 4, pi = c(0.5,0.5,0.5,0.5))
FuncDGP(dgptype = 2, rndflag = 3, n = 200, g = 4, pi = c(0.5,0.5,0.5,0.5))
FuncDGP(dgptype = 2, rndflag = 4, n = 200, g = 4, pi = c(0.5,0.5,0.5,0.5))

FuncDGP(dgptype = 3, rndflag = 1, n = 200, g = 4, pi = c(0.5,0.5,0.5,0.5))
FuncDGP(dgptype = 3, rndflag = 2, n = 200, g = 4, pi = c(0.5,0.5,0.5,0.5))
FuncDGP(dgptype = 3, rndflag = 3, n = 200, g = 4, pi = c(0.5,0.5,0.5,0.5))
FuncDGP(dgptype = 3, rndflag = 4, n = 200, g = 4, pi = c(0.5,0.5,0.5,0.5))
}
\references{
Jiang L, Linton O B, Tang H, Zhang Y. Improving estimation efficiency via regression-adjustment in covariate-adaptive randomizations with imperfect compliance [J]. 2022.
}
