% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw.R
\name{drawPoint}
\alias{drawPoint}
\title{Draw a Point on the Page}
\usage{
drawPoint(x, y, pch = .pkgenv$pointPCH, size = .pkgenv$pointSize,
  fillColor = .pkgenv$pointFillColor, opacity = .pkgenv$pointOpacity,
  lineColor = .pkgenv$pointLineColor, lineWidth = .pkgenv$pointLineWidth,
  lineType = .pkgenv$pointLineType, units = .pkgenv$units, ...)
}
\arguments{
\item{x}{Numeric value for the x-axis position of the center.}

\item{y}{Numeric value for the y-axis position of the center.}

\item{pch}{Numeric value indicating which plotting symbol to use (see \link[graphics]{points}). Some examples include 0 for square, 1 for circle, 2 for triangle, and 4 for X.}

\item{size}{Numeric value for the size of the point.}

\item{fillColor}{Character value for the fill color.}

\item{opacity}{Numeric value for the transparency with values ranging from 0 (transparent) to 1 (non-transparent).}

\item{lineColor}{Character value for the color of the lines.}

\item{lineWidth}{Numeric value for the width of the lines.}

\item{lineType}{Character value for the line type. One of "blank", "solid", "dashed", "dotted", "dotdash", "longdash", or "twodash" (see "lty" in \link[graphics]{par}).}

\item{units}{Character value for the \link[grid]{unit} to use when specifying measurements.}

\item{...}{Additional arguments passed to \link[grid]{grid.points}.}
}
\value{
A \link[grid]{grid.points} \link[grid]{grob} object.
}
\description{
Draws a point on the page given positioning, dimensions and styling.
\cr\cr
\if{html}{\figure{drawpoint.png}{options: width=250 alt="Figure: drawPoint Example"}}
\if{latex}{\figure{drawpoint.png}{options: width=3in alt="Figure: drawPoint Example"}}
}
\examples{
library(draw)

# Set drawing settings
drawSettings(pageWidth = 5, pageHeight = 5, units = "inches")

# Create a new drawing page
drawPage()

# Draw a square point
drawPoint(x = 1, y = 4, pch = 0)

# Draw a larger circle point
drawPoint(x = 4, y = 4, pch = 1, size = 1.5)

# Draw a triangle point
drawPoint(x = 1, y = 1, pch = 2, lineWidth = 2)

# Draw a red X point
drawPoint(x = 4, y = 1, pch = 4, lineColor = "red")

# Export the drawing page to a PDF
drawExport("drawPoint.pdf")

}
\seealso{
\link{drawSettings}
}
