% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw.R
\name{drawCurve}
\alias{drawCurve}
\title{Draw a Curve on the Page}
\usage{
drawCurve(x, y, curvature = .pkgenv$curveCurvature,
  angle = .pkgenv$curveAngle, points = .pkgenv$curvePoints,
  shape = .pkgenv$curveShape, square = .pkgenv$curveSquare,
  squareShape = .pkgenv$curveSquareShape, opacity = .pkgenv$curveOpacity,
  lineColor = .pkgenv$curveLineColor, lineWidth = .pkgenv$curveLineWidth,
  lineType = .pkgenv$curveLineType, inflect = .pkgenv$curveInflect,
  open = .pkgenv$curveOpen, arrowAngle = .pkgenv$arrowAngle,
  arrowLength = .pkgenv$arrowLength, arrowUnits = .pkgenv$arrowUnits,
  arrowEnds = .pkgenv$arrowEnds, arrowType = .pkgenv$arrowType,
  units = .pkgenv$units, ...)
}
\arguments{
\item{x}{Numeric vector of length 2 for x-axis position of starting and ending points.}

\item{y}{Numeric vector of length 2 for y-axis position of starting and ending points.}

\item{curvature}{Numeric value for the curvature of the curve. Values of 0 create a straight line, negative values create left-hand curves, and positive values create right-hand curves.}

\item{angle}{Numeric value of the curve control point skewness ranging from 0 to 180. Values less than 90 skew towards the start point, and values more than 90 skew towards the end point.}

\item{points}{Numeric value for the number of curve control points with higher numbers creating a smoother curve.}

\item{shape}{Numeric value for the shape of the curve ranging from -1 to 1 (See \link[grid]{grid.xspline}).}

\item{square}{Logical value indicating whether curve control points are created in a city-block or oblique way. It is recommended to set this to TRUE if \emph{points} is 1 and \emph{angle} is 90, and FALSE otherwise (see \link[grid]{grid.curve}).}

\item{squareShape}{Numeric value controlling curve behaviours relative to control points. Applies if \emph{square} is TRUE.}

\item{opacity}{Numeric value for the transparency with values ranging from 0 (transparent) to 1 (non-transparent).}

\item{lineColor}{Character value for the color of the lines.}

\item{lineWidth}{Numeric value for the width of the lines.}

\item{lineType}{Character value for the line type. One of "blank", "solid", "dashed", "dotted", "dotdash", "longdash", or "twodash" (see "lty" in \link[graphics]{par}).}

\item{inflect}{Logical value indicating if the curve should be cut in half and inverted (TRUE) or not (FALSE).}

\item{open}{Logical value indicating whether to open the curve (TRUE) or close the curve (FALSE).}

\item{arrowAngle}{Numeric value of the angle for arrows. Smaller numbers create narrower arrows, and larger numbers produce wider arrows.}

\item{arrowLength}{Numeric value of the length for arrows.}

\item{arrowUnits}{Character value of the measurement unit for arrows.}

\item{arrowEnds}{Character value indicating which end to draw arrows on lines. Must be one of "last", "first" or "both".}

\item{arrowType}{Character value indicating if the arrow heads should be closed or open. Must be one of "open" or "closed".}

\item{units}{Character value for the \link[grid]{unit} to use when specifying measurements.}

\item{...}{Additional arguments passed to \link[grid]{grid.curve}.}
}
\value{
A \link[grid]{grid.curve} \link[grid]{grob} object.
}
\description{
Draws a curve on the page given positioning, dimensions and styling.
\cr\cr
\if{html}{\figure{drawcurve.png}{options: width=250 alt="Figure: drawCurve Example"}}
\if{latex}{\figure{drawcurve.png}{options: width=3in alt="Figure: drawCurve Example"}}
}
\examples{
library(draw)

# Set drawing settings
drawSettings(pageWidth = 5, pageHeight = 5, units = "inches")

# Create a new drawing page
drawPage()

# Draw a curved angle
drawCurve(x = c(1, 4),
          y = c(1, 2),
          angle = 90)

# Draw a curved angle with arrows
drawCurve(x = c(1, 4),
          y = c(2, 3.75),
          angle = 90, arrowLength = 0.1, arrowEnd = "both")

# Draw an inflected curve
drawCurve(x = c(1, 4),
          y = c(3, 4),
          angle = 90, inflect = TRUE)

# Export the drawing page to a PDF
drawExport("drawCurve.pdf")

}
\seealso{
\link{drawSettings}
}
