% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw.R
\name{drawCircle}
\alias{drawCircle}
\title{Draw a Circle on the Page}
\usage{
drawCircle(x, y, radius = .pkgenv$circleRadius,
  fillColor = .pkgenv$circleFillColor, opacity = .pkgenv$circleOpacity,
  lineColor = .pkgenv$circleLineColor, lineWidth = .pkgenv$circleLineWidth,
  lineType = .pkgenv$circleLineType, units = .pkgenv$units, ...)
}
\arguments{
\item{x}{Numeric value for the x-axis position of the center.}

\item{y}{Numeric value for the y-axis position of the center.}

\item{radius}{Numeric value for radius of the circle.}

\item{fillColor}{Character value for the fill color.}

\item{opacity}{Numeric value for the transparency with values ranging from 0 (transparent) to 1 (non-transparent).}

\item{lineColor}{Character value for the color of the lines.}

\item{lineWidth}{Numeric value for the width of the lines.}

\item{lineType}{Character value for the line type. One of "blank", "solid", "dashed", "dotted", "dotdash", "longdash", or "twodash" (see "lty" in \link[graphics]{par}).}

\item{units}{Character value for the \link[grid]{unit} to use when specifying measurements.}

\item{...}{Additional arguments passed to \link[grid]{grid.circle}}
}
\value{
A \link[grid]{grid.circle} \link[grid]{grob} object.
}
\description{
Draws a circle on the page given positioning, dimensions and styling.
\cr\cr
\if{html}{\figure{drawcircle.png}{options: width=250 alt="Figure: drawCircle Example"}}
\if{latex}{\figure{drawcircle.png}{options: width=3in alt="Figure: drawCircle Example"}}
}
\examples{
library(draw)

# Set drawing settings
drawSettings(pageWidth = 5, pageHeight = 5, units = "inches")

# Create a new drawing page
drawPage()

# Draw a small circle
drawCircle(x = 2.5, y = 2.5, radius = 0.5)

# Draw a mid sized circle
drawCircle(x = 2.5, y = 2.5, radius = 1)

# Draw a large circle
drawCircle(x = 2.5, y = 2.5, radius = 2)

# Export the drawing page to a PDF
drawExport("drawCircle.pdf")

}
\seealso{
\link{drawSettings}
}
