% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_tests.R
\name{dk_test}
\alias{dk_test}
\title{Statistical test to identify dragon kings (DKs)}
\usage{
dk_test(vals, r)
}
\arguments{
\item{vals}{numeric vector with at least 3 elements}

\item{r}{integer indicating number of DKs in \code{vals}}
}
\value{
DK test statistic and p-value (F distribution)
}
\description{
\code{dk_test} runs the DK test on the user parameters and returns a
test statistic and corresponding p-value to aid in determining whether
there is significant support for the existence of \code{r} DKs in
\code{vals}.
}
\examples{
# generate a numeric vector with DKs
temp <- c(rexp(100),   # exponentially distributed RV
          15, 15, 15)  # DK elements

# test for DKs, where r is number of DKs thought to be in temp
results <- dk_test(temp, r = 3)

# print out test statistic (should be large) and p-value (should be small)
print(paste("Test statistic =", results["Test Statistic"]))
print(paste("p-value =", results["p-value"]))
}
\references{
Wheatley S, Sornette D (2015). Multiple outlier detection in samples with exponential & pareto tails: Redeeming the inward approach & detecting dragon kings. Swiss Finance Institute Research Paper Series No. 15-28. <doi:10.2139/ssrn.2645709>

Pisarenko VF, Sornette D (2012). Robust statistical tests of dragon-kings beyond power law distributions. \emph{Eur Phys J Special Topics}, \strong{205}: 95-115. <doi:10.1140/epjst/e2012-01564-8>
}
