% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cca0.R
\name{cca0}
\alias{cca0}
\title{Performs a canonical correspondence analysis}
\usage{
cca0(
  formula,
  response = NULL,
  data,
  traceonly = FALSE,
  cca_object = NULL,
  object4QR = NULL
)
}
\arguments{
\item{formula}{one or two-sided formula for the rows (samples) with row 
predictors in \code{data}. The left hand side of the formula is ignored if
it is specified in the next argument (\code{response}). Specify row 
covariates (if any ) by adding \code{+ Condition(covariate-formula)} to 
\code{formula} as in \code{\link[vegan]{rda}}. The \code{covariate-formula}
should not contain a \code{~} (tilde).}

\item{response}{matrix or data frame of the abundance data (dimension 
\emph{n} x \emph{m}). Rownames of \code{response}, if any, are carried 
through. BEWARE: all rows and columns should have positive sums!
Can be \code{NULL} if \code{cca_object} is supplied or 
if the response is \code{formula} is two-sided.}

\item{data}{matrix or data frame of the row predictors, with rows 
corresponding to those in \code{response} (dimension \emph{n} x \emph{p}).}

\item{traceonly}{logical, default \code{FALSE}. If \code{TRUE}, only 
the explained variance of the predictors and the \code{Condition()}
are returned, \emph{i.e} without performing a singular value
decompostion.}

\item{cca_object}{a vegan-type cca-object of \emph{transposed} 
\code{response}, from which chisq_residuals and row and column weights can 
be obtained.}

\item{object4QR}{a vegan-type cca-object with weighted QR's for 
\code{formula}, i.e. \code{qr(Z)} and \code{qr(XZ)} obtainable via 
\code{get_QR(object4QR, model = "pCCA")} and
\code{get_QR(object4QR, model = "CCA")}, respectively.}
}
\value{
All scores in the \code{cca0} object are in scaling \code{"sites"} (1): 
the scaling with \emph{Focus on Case distances}.

The returned object has class \code{c("cca0" "wrda")} so that
the methods \code{print}, \code{predict} and \code{scores}
can use the \code{wrda} variant.
}
\description{
\code{cca0} is formula-based implementation of canonical correspondence 
analysis.
}
\details{
The algorithm is a wrda on the abundance data
after transformation to chi-square residuals. 

It is much slower than \code{\link[vegan]{cca}}. The only reason to use
it, is that \code{\link{anova.cca0}} does residualized predictor permutation.
It is unknown to the authors of \code{douconca} which method
\code{\link[vegan]{anova.cca}} implements. See \code{\link{anova.cca0}}.

Compared to  \code{\link[vegan]{cca}}, \code{cca0} does not have residual 
axes, \emph{i.e.} no CA of the residuals is performed.
}
\examples{
data("dune_trait_env")

# rownames are carried forward in results
rownames(dune_trait_env$comm) <- dune_trait_env$comm$Sites
abun <- dune_trait_env$comm[, -1]  # must delete "Sites"

mod <- cca0(formula = abun ~ A1 + Moist + Mag + Use + Manure,
            data = dune_trait_env$envir)

mod # Proportions equal to those Canoco 5.15

scores(mod, which_cor = c("A1", "X_lot"), display = "cor")

set.seed(123)
anova(mod)
anova(mod, by = "axis")

mod2 <- vegan::cca(abun ~ A1 + Moist + Mag + Use + Manure,
                   data = dune_trait_env$envir)
anova(mod2, by = "axis")

dat <- dune_trait_env$envir
dat$Mag <- "SF"
predict(mod, type = "lc", newdata = dat)
}
\references{
ter Braak C.J.F. and  P. Šmilauer  (2018). Canoco reference manual
and user's guide: software for ordination (version 5.1x).
Microcomputer Power, Ithaca, USA, 536 pp.

Oksanen, J., et al. (2022)
vegan: Community Ecology Package. R package version 2.6-8.
\url{https://CRAN.R-project.org/package=vegan}.
}
\seealso{
\code{\link{scores.wrda}}, \code{\link{anova.cca0}},
\code{\link{print.wrda}} and \code{\link{predict.wrda}}
}
