% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opti_helpers.R
\name{max_expectation}
\alias{max_expectation}
\title{A function to compute a conservative upper bound on the worst-case expectation
under the sharp null}
\usage{
max_expectation(z, gamma, f_pi, with_variance = FALSE)
}
\arguments{
\item{z}{vector of doses of length n}

\item{gamma}{The nonnegative sensitivity parameter; gamma = 0 means no
unmeasured confounding.}

\item{f_pi}{a vector of length n! that contains the value of the test statistic
under each of the n! permutations of z, with order of f_pi determined by first
sorting z into increasing order and calling gtools::permutations on z.}

\item{with_variance}{whether to return the variance along with the worst-case
expectation, default is FALSE.}
}
\value{
a list containing the worst-case expectation, and/or variance and the
solution to the optimization problem.
}
\description{
A function to compute a conservative upper bound on the worst-case expectation
under the sharp null
}
\examples{
# A vector of observed doses
doses <- c(0, 0.1, 0.4, 0.8)
# values of test statistic under 4! permutations
values <- c(1, 0.5, 0.3, 0.8, 1, 0.7)
upper_bound <- max_expectation(z = doses, gamma = 1, f_pi = values)
}
