% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doremi.R
\name{generate.panel.2order}
\alias{generate.panel.2order}
\title{Generation of second order differential equation solutions for several individuals with intra-individual and inter-individual noise}
\usage{
generate.panel.2order(
  time,
  excitation = NULL,
  y0 = 1,
  v0 = 0,
  t0 = NULL,
  xi = 0.1,
  period = 10,
  k = 1,
  yeq = 0,
  nind = 1,
  internoise = 0,
  intranoise = 0
)
}
\arguments{
\item{time}{is a vector containing the time values corresponding to the excitation signal.}

\item{excitation}{Is a vector containing the values of the excitation signal.}

\item{y0}{is the initial condition for the variable y(t=t0), (0, by default), it is a scalar.}

\item{v0}{is the initial condition for the derivative dy(t=t0), (0, by default), it is a scalar.}

\item{t0}{is the time corresponding to the initial condition y0 and v0. Default is the minimum value of the time vector.}

\item{xi}{is the damping factor. A negative value will produce divergence from equilibrium.}

\item{period}{is the period T of the oscillation, \eqn{T = \frac{2*\pi}{\omega_{n}}} as mentioned}

\item{k}{Default is 1. It represents the proportionality between the stationary increase of signal and the excitation increase that caused it.
Only relevant if the excitation is non null.}

\item{yeq}{is the signal equilibrium value, i.e. the stationary value reached when the excitation term is 0.}

\item{nind}{number of individuals.}

\item{internoise}{Is the inter-individual noise added. The damping factor across individuals follows a normal distribution centered on the input parameter xi
with a standard deviation of internoise*xi. The same applies to the other coefficients of the differential equation (T,k and yeq) and to the initial conditions (y0 and v0)}

\item{intranoise}{Is the noise to signal  ratio: dynamic noise added to each signal defined as the ratio between the variance  of the noise and the variance of the signal}
}
\value{
Returns a data frame with signal and time values for the time and excitation vectors provided.
It contains the following columns:
\itemize{
   \item id - individual identifier (from 1 to nind).
   \item excitation - excitation signal provided as input
   \item time - time values provided as input
   \item signalraw - signal with no noise (inter noise added for each individual)
   \item signal - signal with intra noise added
}
}
\description{
\code{generate.panel.2order} Generation of second order differential equation solutions for several individuals with intra-individual and inter-individual noise.
The function generates the equation coefficients following a normal distribution based on the parameter internoise and the coefficients provided as input.
It then calls the function \code{\link{generate.2order}} to generate a solution of a second order differential equation with these parameters for the nind individuals.
Finally it adds measurement noise to each signal according to the value of the parameter intranoise.
}
\details{
Used for simulations in the context of the package.
}
\examples{
generate.panel.2order(time = generate.excitation(3, 6, 2, 1, 200, 2)$t,
                      excitation = generate.excitation(3, 6, 2, 1, 200, 2)$exc,
                      xi = 0.1,
                      period = 0.5,
                      k = 1,
                      nind = 5,
                      internoise = 0.2,
                      intranoise = 0.1)
}
\seealso{
\code{\link{generate.2order}} for calculation of the numerical solution to the second order differential equation
and \code{\link{generate.excitation}} for excitation signal generation
}
\keyword{second-order}
\keyword{simulation}
