% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dnafractal.R
\name{dnafractal}
\alias{dnafractal}
\title{Generates a Fractal Image of a DNA Sequence}
\arguments{
\item{mx}{a DNA sequence}

\item{start}{the starting position in the sequence to be fractalized}

\item{end}{the ending position in the sequence to be fractalized}

\item{cex}{the size of the dots in the fractal image}

\item{dotcol}{the color of the fractal image dots}
}
\value{
nil
}
\description{
The function takes a DNA sequence up to 100 Kbp, a start point, an end point in the sequence,
dot size and dot color and draws a fractal image of the sequence. The fractal starts in
the center of the canvas. The image is drawn by moving base by base along the sequence
and dropping a midpoint between the actual point and the corner designated by the actual
base.

Version 0.0.1.
Author: Dr. Matthew Cserhati
Email: matthew.cserhati@cui.edu
May 5, 2025
}
\examples{
dnafractal(human_mitogenome)
dnafractal(human_mitogenome,start=100,end=1000)
dnafractal(human_mitogenome,cex=1,dotcol="blue")
}
\references{
Jeffrey, H. J. (1990) Chaos game representation of gene structure. Nucleic Acids Research 18(8):2163-70.

Hill, K. A., Schisler, N. J., and Singh, S. M. (1992) Chaos game representation of coding regions of human globin genes and alcohol dehydrogenase genes of phylogenetically divergent species. Journal of Molecular Evolution 35:261-269.

Löchel, H. F., and Heider, D. (2021) Chaos game representation and its applications in bioinformatics. Computational and Structural Biotechnology Journal 19(2021): 6263-6271.
}
