% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bioc_stats.R
\name{bioc_stats}
\alias{bioc_stats}
\title{bioc_stats}
\usage{
bioc_stats(packages, use_cache = TRUE, type = "Software")
}
\arguments{
\item{packages}{packages}

\item{use_cache}{logical, should cached data be used? Default: TRUE. If set to FALSE, it will
re-query download stats and update cache.}

\item{type}{one of "Software", "AnnotationData", "ExperimentData", and "Workflow"}
}
\value{
data.frame
}
\description{
monthly download stats of Bioconductor package(s)
}
\examples{
\dontrun{
library("dlstats")
pkgs <- c("ChIPseeker", "clusterProfiler", "DOSE", "ggtree", "GOSemSim", "ReactomePA")
y <- bioc_stats(pkgs, use_cache=TRUE)
head(y)
}
}
\author{
Guangchuang Yu
}
