% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/episodes.R
\name{episodes_wf_splits}
\alias{episodes_wf_splits}
\title{Link events to chronological episodes.}
\usage{
episodes_wf_splits(..., duplicates_recovered = "ANY", reframe = FALSE)
}
\arguments{
\item{...}{Arguments passed to \code{\link{episodes}}.}

\item{duplicates_recovered}{\code{[character]}. Determines which duplicate records are recycled.
Options are \code{"ANY"} (default), \code{"without_sub_criteria"}, \code{"with_sub_criteria"} or \code{"ALL"}. See \code{Details}.}

\item{reframe}{\code{[logical]}. Determines if the duplicate records in a \code{\link{sub_criteria}} are reframed (\code{TRUE}) or excluded (\code{FALSE}).}
}
\value{
\code{\link[=epid-class]{epid}}; \code{list}
}
\description{
\code{episodes_wf_splits} is a wrapper function of \code{\link{episodes}}.
It's designed to be more efficient with larger datasets.
Duplicate records which do not affect the case definition are excluded prior to episode tracking.
The resulting episode identifiers are then recycled for the duplicate records.
}
\details{
\bold{\code{episodes_wf_splits()}} reduces or re-frames a dataset to
the minimum datasets required to implement a case definition.
This leads to the same outcome but with the benefit of a shorter processing time.

The \code{duplicates_recovered} argument determines which identifiers are recycled.
Selecting the \code{"with_sub_criteria"} option will force only identifiers created resulting from a matched \code{\link{sub_criteria}} (\code{"Case_CR"} and \code{"Recurrent_CR"}) are recycled.
However, if \code{"without_sub_criteria"} is selected then only identifiers created that do not result from a matched \code{\link{sub_criteria}} (\code{"Case"} and \code{"Recurrent"}) are recycled
Excluded duplicates of \code{"Duplicate_C"} and \code{"Duplicate_R"} are always recycled.

The \code{reframe} argument will either \code{\link{reframe}} or subset a \code{\link{sub_criteria}}.
Both will require slightly different functions for \code{match_funcs} or \code{equal_funcs}.
}
\examples{
# With 2,000 duplicate records of 20 events,
# `episodes_wf_splits()` will take less time than `episodes()`
dates <- seq(from = as.Date("2019-04-01"), to = as.Date("2019-04-20"), by = 1)
dates <- rep(dates, 2000)

system.time(
  ep1 <- episodes(dates, 1)
)
system.time(
  ep2 <- episodes_wf_splits(dates, 1)
)

# Both leads to the same outcome.
all(ep1 == ep2)
}
\seealso{
\code{\link{episodes}}; \code{\link{sub_criteria}}
}
