% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Frechet.R
\name{Frechet}
\alias{Frechet}
\title{Create a Frechet distribution}
\usage{
Frechet(location = 0, scale = 1, shape = 1)
}
\arguments{
\item{location}{The location (minimum) parameter \eqn{m}.
\code{location} can be any real number.  Defaults to \code{0}.}

\item{scale}{The scale parameter \eqn{s}.
\code{scale} can be any positive number.  Defaults to \code{1}.}

\item{shape}{The shape parameter \eqn{\alpha}.
\code{shape} can be any positive number.  Defaults to \code{1}.}
}
\value{
A \code{Frechet} object.
}
\description{
The Frechet distribution is a special case of the \verb{\link{GEV}} distribution,
obtained when the GEV shape parameter \eqn{\xi} is positive.
It may be referred to as a type II extreme value distribution.
}
\details{
We recommend reading this documentation on
\url{https://alexpghayes.github.io/distributions3/}, where the math
will render with additional detail and much greater clarity.

In the following, let \eqn{X} be a Frechet random variable with location
parameter  \code{location} = \eqn{m}, scale parameter \code{scale} =
\eqn{s}, and shape parameter \code{shape} = \eqn{\alpha}.
A Frechet(\eqn{m, s, \alpha}) distribution is equivalent to a
\verb{\link{GEV}}(\eqn{m + s, s / \alpha, 1 / \alpha}) distribution.

\strong{Support}: \eqn{(m, \infty)}.

\strong{Mean}: \eqn{m + s\Gamma(1 - 1/\alpha)}, for \eqn{\alpha > 1}; undefined
otherwise.

\strong{Median}: \eqn{m + s(\ln 2)^{-1/\alpha}}{m + s(\ln 2)^(-1/\alpha)}.

\strong{Variance}:
\eqn{s^2 [\Gamma(1 - 2 / \alpha) - \Gamma(1 - 1 / \alpha)^2]}
for \eqn{\alpha > 2}; undefined otherwise.

\strong{Probability density function (p.d.f)}:

\deqn{f(x) = \alpha s ^ {-1} [(x - m) / s] ^ {-(1 + \alpha)}%
        \exp\{-[(x - m) / s] ^ {-\alpha} \}}{%
       f(x) = (\alpha / s) [(x - m) / s] ^ [-(1 + \alpha)]%
        exp{-[(x - m) / s] ^ (-\alpha)}}
for \eqn{x > m}.  The p.d.f. is 0 for \eqn{x \leq m}{x <= m}.

\strong{Cumulative distribution function (c.d.f)}:

\deqn{F(x) = \exp\{-[(x - m) / s] ^ {-\alpha} \}}{%
       F(x) = exp{-[(x - m) / s] ^ (-\alpha)}}
for \eqn{x > m}.  The c.d.f. is 0 for \eqn{x \leq m}{x <= m}.
}
\examples{

set.seed(27)

X <- Frechet(0, 2)
X

random(X, 10)

pdf(X, 0.7)
log_pdf(X, 0.7)

cdf(X, 0.7)
quantile(X, 0.7)

cdf(X, quantile(X, 0.7))
quantile(X, cdf(X, 0.7))
}
\seealso{
Other continuous distributions: 
\code{\link{Beta}()},
\code{\link{Cauchy}()},
\code{\link{ChiSquare}()},
\code{\link{Erlang}()},
\code{\link{Exponential}()},
\code{\link{FisherF}()},
\code{\link{GEV}()},
\code{\link{GP}()},
\code{\link{Gamma}()},
\code{\link{Gumbel}()},
\code{\link{LogNormal}()},
\code{\link{Logistic}()},
\code{\link{Normal}()},
\code{\link{RevWeibull}()},
\code{\link{StudentsT}()},
\code{\link{Tukey}()},
\code{\link{Uniform}()},
\code{\link{Weibull}()}
}
\concept{continuous distributions}
