% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distcomp-package.R
\name{uploadNewNCP}
\alias{uploadNewNCP}
\title{Upload a new Non-Cooperating Party (NCP) information and sites to
an opencpu server}
\usage{
uploadNewNCP(defn, comp_defn, url = NULL, worker = NULL, sites)
}
\arguments{
\item{defn}{a definition for the NCP}

\item{comp_defn}{the computation definition}

\item{url}{the url for the NCP. Only one of url and worker can be
non-null}

\item{worker}{the worker for the NCP if local. Only one of url and
worker can be non-null}

\item{sites}{a list of lists, each containing two items, a unique
\code{name} and a (not necessarily unique) \code{url}. This is the data
for the NCP!}
}
\value{
TRUE if everything goes well
}
\description{
The function \code{uploadNewNCP} is really a remote version
of \code{\link[=saveNewNCP]{saveNewNCP()}}, invoking that function on an opencpu server.
This is typically done for the two NCPs participating in a
computation with the list of sites. Note that sites are always
a list of at least a unique name element (distinguishing the
site from others) and a url element.
}
\seealso{
\code{\link[=saveNewNCP]{saveNewNCP()}}
}
