% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zoo_simulate.R
\name{zoo_simulate}
\alias{zoo_simulate}
\title{Simulate a Zoo Time Series}
\usage{
zoo_simulate(
  name = "A",
  cols = 5,
  rows = 100,
  time_range = c("2010-01-01", "2020-01-01"),
  data_range = c(0, 1),
  seasons = 0,
  na_fraction = 0,
  independent = FALSE,
  irregular = TRUE,
  seed = NULL
)
}
\arguments{
\item{name}{(optional, character string) Name of the zoo object, to be stored in the attribute "name". Default: "A"}

\item{cols}{(optional, integer) Number of time series. Default: 5}

\item{rows}{(optional, integer) Length of the time series. Minimum is 10, but maximum is not limited. Very large numbers might crash the R session. Default: 100}

\item{time_range}{(optional character or numeric vector) Interval of the time series. Either a character vector with dates in format YYYY-MM-DD or or a numeric vector. If there is a mismatch between \code{time_range} and \code{rows} (for example, the number of days in \code{time_range} is smaller than \code{rows}), the upper value in \code{time_range} is adapted to \code{rows}. Default: c("2010-01-01", "2020-01-01")}

\item{data_range}{(optional, numeric vector of length 2) Extremes of the simulated time series values. The simulated time series are independently adjusted to random values within the provided range. Default: c(0, 1)}

\item{seasons}{(optional, integer) Number of seasons in the resulting time series. The maximum number of seasons is computed as \code{floor(rows/3)}. Default: 0}

\item{na_fraction}{(optional, numeric) Value between 0 and 0.5 indicating the approximate fraction of NA data in the simulated time series. Default: 0.}

\item{independent}{(optional, logical) If TRUE, each new column in a simulated time series is averaged with the previous column. Irrelevant when \code{cols <= 2}, and hard to perceive in the output when \code{seasons > 0}. Default: FALSE}

\item{irregular}{(optional, logical) If TRUE, the time series is created with 20 percent more rows, and a random 20 percent of rows are removed at random. Default: TRUE}

\item{seed}{(optional, integer) Random seed used to simulate the zoo object. Default: NULL}
}
\value{
zoo object
}
\description{
Generates simulated zoo time series.
}
\examples{

#generates a different time series on each execution when 'seed = NULL'
x <- zoo_simulate()

#returns a zoo object
class(x)

#time series names are uppercase letters
#this attribute is not defined in the zoo class and might be lost during data transformations
attributes(x)$name

#column names are lowercase letters
names(x)

#plotting methods
if(interactive()){

  #plot time series with default zoo method
  plot(x)

  #plot time series with distantia
  zoo_plot(
    x = x,
    xlab = "Date",
    ylab = "Value",
    title = "My time series"
  )

}
}
\seealso{
Other simulate_time_series: 
\code{\link{tsl_simulate}()}
}
\concept{simulate_time_series}
