% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataSets.R
\docType{data}
\name{unempMultiSpell}
\alias{unempMultiSpell}
\title{Multiple Spell employment data}
\source{
\href{https://www.nlsinfo.org/content/cohorts/NLSY97}{National Longitudinal Survey of Youth}
}
\usage{
data(unempMultiSpell)
}
\description{
Subsample of 1000 persons from the national longitudinal survey of youth 1979 data. 
Included covariates are age, children, ethnicity, marital status and sex. 
The bivariate responses current state (spell) and discrete time interval (year) are 
the last two columns.
}
\details{
\itemize{
  \item Column "id" is defined as identification number for each person.
}
\itemize{
  \item Column "age" represents the time-varying age of each person in years.
}
\itemize{
  \item Column "child" consists of values \itemize{
  \item 0 - No children
  \item 1 - Individual has child/children
  }
}
\itemize{
  \item Column "ethnicity" consists of values \itemize{
  \item 1 - Hispanic
  \item 2 - Black
  \item 3 - Other
  }
}
\itemize{
  \item Column "marriage" consists of values \itemize{
  \item 1 - Never Married
  \item 2 - Currently married
  \item 3 - Other/Divorced
  }
}
\itemize{
  \item Column "sex" consists of values \itemize{
  \item 1 - Male
  \item 2 - Female
  }
}
\itemize{
  \item Column "spell" represents the time-varying employment status of each person. 
  Possible values are \itemize{
  \item 1 - Employed
  \item 2 - Unemployed
  \item 3 - Out of labor force
  \item 4 - In active forces
  \item 0 - Censored
  }
}
\itemize{
  \item Column "year" represents the discrete time intervals in years.
}
}
\author{
David Koehler \email{koehler@imbie.uni-bonn.de}
}
\keyword{data}
