% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survTreeLaplaceHazards.R
\name{survTreeLaplaceHazard}
\alias{survTreeLaplaceHazard}
\title{Laplace Hazards for a Competing Risk Survival Tree Object}
\usage{
survTreeLaplaceHazard(treeModel, newdata, lambda)
}
\arguments{
\item{treeModel}{Fitted tree object as generated by "rpart" ("class rpart").}

\item{newdata}{Data in long format for which hazards are to be computed. Must 
contain the same columns that were used for tree fitting("class data.frame").}

\item{lambda}{Smoothing parameter for laplace-smoothing. Must be a non-negative 
number. A value of 0 corresponds to no smoothing ("numeric vector").}
}
\value{
A m by k matrix with m being the length of newdata and k being the 
number of classes in treeModel. Each row corresponds to the smoothed hazard 
of the respective observation.
}
\description{
Predicts the laplace-smoothed hazards of discrete survival tree. 
Can be used for single-risk or competing risk discrete survival data.
}
\examples{
library(pec)
library(caret)
# Example data
data(cost)
# Convert time to years and select training and testing subsample
cost$time <- ceiling(cost$time/365)
costTrain <- cost[1:100, ]
costTest  <- cost[101:120, ]
# Convert to long format
timeColumn <- "time"
eventColumn <- "status"
costTrainLong <- dataLong(dataShort=costTrain, timeColumn = "time", 
                          eventColumn = "status")
costTestLong  <- dataLong(dataShort=costTest, timeColumn = "time", 
                          eventColumn = "status")
head(costTrainLong)
# Fit a survival tree
costTree <- rpart(formula = y ~ timeInt + prevStroke + age + sex, data = costTrainLong, 
                  method = "class")
# Compute smoothed hazards for test data
predictedhazards <- survTreeLaplaceHazard(costTree, costTestLong, 1)
predictedhazards
}
\keyword{survival}
