% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiscSurvEvaluation.R
\name{martingaleResid}
\alias{martingaleResid}
\alias{plot.discSurvMartingaleResid}
\title{Martingale Residuals}
\usage{
martingaleResid(hazards, dataSetLong)

\method{plot}{discSurvMartingaleResid}(x, covariates, dataSetLong, ...)
}
\arguments{
\item{hazards}{Predicted hazards from a discrete survival model ("numeric vector").}

\item{dataSetLong}{Data in long format ("class data.frame").}

\item{x}{Object of class "discSurvMartingaleResid"("class discSurvMartingaleResid")}

\item{covariates}{Names of covariates to plot ("character vector").}

\item{\dots}{Additional arguments to the plot function}
}
\value{
Martingale residuals for each observation in long format ("numeric vector").
}
\description{
Estimates the martingale residuals of discrete survival model.
}
\details{
Gives a different plot of each marginal covariate against the martingale
residuals. Additionally a nonparametric \code{\link{loess}} estimation is
done.
}
\examples{

# Example with cross validation and unemployment data 
library(Ecdat)
data(UnempDur)
summary(UnempDur$spell)

# Extract subset of data
set.seed(635)
IDsample <- sample(1:dim(UnempDur)[1], 100)
UnempDurSubset <- UnempDur [IDsample, ]

# Conversion to long format
UnempDurSubsetLong <- dataLong(dataShort = UnempDurSubset,
timeColumn = "spell", eventColumn = "censor1")

# Estimate discrete survival continuation ratio model
contModel <- glm(y ~ timeInt + age + logwage, data = UnempDurSubsetLong,
family = binomial(link = "logit"))

# Fit hazards to the data set in long format
hazPreds <- predict(contModel, type = "response")

# Calculate martingale residuals for the unemployment data subset
MartResid <- martingaleResid (hazards = hazPreds, dataSetLong = UnempDurSubsetLong)
MartResid
sum(MartResid)

# Plot martingale residuals vs each covariate in the event interval
# Dotted line represents the loess estimate
plot(MartResid, covariates = c("age", "logwage"), dataSetLong = UnempDurSubsetLong)

}
\references{
\insertRef{tutzModelDisc}{discSurv} \cr\cr
\insertRef{therneauMart}{discSurv}
}
\seealso{
\code{\link[stats]{glm}}
}
\author{
Thomas Welchowski \email{welchow@imbie.meb.uni-bonn.de}
}
\keyword{internal}
