% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AUC_add_zeros.R
\name{AUC_zeros}
\alias{AUC_zeros}
\title{Impute zero delay/100\% likely indifference points}
\usage{
AUC_zeros(dat, indiff, x_axis, amount, groupings = NULL, prob_disc = FALSE)
}
\arguments{
\item{dat}{Discounting data tibble}

\item{indiff}{Indifference points Variable}

\item{x_axis}{Delays/probabilities/social distance variable}

\item{amount}{Amount of the larger delayed/probablistic/etc. outcome
(A in discounting formulas)}

\item{groupings}{Variables for grouping (e.g., subject, expeirmental group)
as a character or vector of characters}

\item{prob_disc}{Boolean for probability discounting, if set to true
function will calculate and report odds against \code{x_axis}}
}
\value{
Tibble that is grouped by \code{groupings} but in the same
order as supplied to the function. If \code{prob_disc == FALSE}, then the
function will add indifference points of \code{amount} at \code{x_axis = 0}.
If \code{prob_disc == TRUE}, then the
function will add indifference points of \code{amount} at \code{x_axis = 1}.
Additionally, a \code{orig} column will be added to indicate whether the
indifference point was included in the data or was imputed.
}
\description{
As defined by Myerson et al. (2001) the indifference point at 0 delay (100\%
likelihood) is set to 0. This function will add that indifference point,
wherever it is missing. If the 0 delay (100\% likelihood) is included in the
data then it will not be overwritten.
}
\examples{
AUC_zeros(
  examp_DD,
  indiff = "prop_indiff",
  x_axis = "delay_months",
  amount = 1,
  groupings = c("subject", "outcome")
)

AUC_zeros(
  examp_PD,
  indiff = "prop_indiff",
  x_axis = "prob",
  amount = 1,
  groupings = c("subject", "outcome"),
  prob_disc = TRUE
)
}
