% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.dirichletprocess}
\alias{print.dirichletprocess}
\title{Print the Dirichlet process object}
\usage{
\method{print}{dirichletprocess}(x, param_summary = FALSE, digits = 2, ...)
}
\arguments{
\item{x}{Dirichlet Process Object to print.}

\item{param_summary}{If \code{TRUE}, print the overall averages of each
parameter of the model. Note that this averages over all clusters and over
all iterations, so it will only give a loose sense of the resulting DPM
model.}

\item{digits}{Integer; Number of digits to display.}

\item{...}{Further arguments passed to or from other methods.}
}
\description{
Print a Dirichlet process object. This will print some basic information
about the \code{dirichletprocess} object.
}
\examples{
dp <- Fit(DirichletProcessGaussian(rnorm(10)), 100)
dp

}
