% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wilms.data.R
\docType{data}
\name{wilms.data}
\alias{wilms.data}
\title{DNA copy number data from  Wilms' tumor}
\format{
A 97 by 3288 numeric matrix containing DNA copy number data, as described below.
}
\source{
\url{https://www.ebi.ac.uk/biostudies/arrayexpress} accession number E-TABM-10.
}
\usage{
wilms.data
}
\description{
Probe-level DNA copy number data from Wilms' tumor (Natrajan et al., 2006)
}
\details{
Natrajan et al. (J. Pathology (2006) 210:  49 - 58) used array comparative genomic
hybridization to obtain genome-wide DNA copy number data from 97 Wilms' tumor samples at
3288 markers.  This matrix contains the DNA copy number data after applying the bias-correction
procedure outlined in Bioinformatics (2011) 27(5) 678 - 685.  Each row corresponds to DNA copy
number from one subject at 3288 markers, while each column contains DNA copy number data for
97 subjects at one marker.
}
\keyword{datasets}
