% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeCytoband.R
\name{makeCytoband}
\alias{makeCytoband}
\title{Find the chromosome arm for each marker}
\usage{
makeCytoband(marker.data, annot.file, reformat.annot = FALSE)
}
\arguments{
\item{marker.data}{A two-column numeric matrix of marker position data for markers in the autosomes.
Column 1 contains the chromosome number for each marker, and column 2 contains the position (in base
pairs) for each marker.  This is a submatrix of the marker position matrix used by \code{\link{quickLook}}
and \code{\link{detailedLook}}.}

\item{annot.file}{A dataframe containing cytoband annotation for the autosomes.  Each row corresponds to a
distinct cytoband, and column 1 contains the chromosome number, column 2 contains the start position (in
base pairs), column 3 contains the end position (in base pairs), and column 4 contains the cytoband name
(e.g. p21.3).  Additional columns may be present, but they are not used.}

\item{reformat.annot}{A logical value that indicates whether \code{annot.file} needs to be reformatted.}
}
\value{
A character vector of length m, where m is the number of markers.
}
\description{
Find the chromosome arm for each marker
}
\details{
DiNAMIC's peeling procedure is detailed in Bioinformatics (2011) 27(5) 678 - 685, and it is performed
by the \code{\link{peeling}} function.  By construction, the peeling procedure only affects markers in a given
chromosome arm.  This function is used internally by the \code{\link{peeling}} function to restrict the peeling
procedure to the chromosome arm containing the marker that corresponds to \code{max(colSums(x))}.
}
\examples{
wilms.pq = makeCytoband(wilms.markers, annot.file)
#A character vector of length 3288, and each entry is either
#"p" or "q", depending on the chromosome arm of the given marker.
table(wilms.pq)
#Produces the following output:
#wilms.pq
#   p    q 
#1147 2141 

}
