% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/privacy_params.R
\docType{class}
\name{DPParamsGam-class}
\alias{DPParamsGam-class}
\alias{DPParamsGam}
\alias{show,DPParamsGam-method}
\alias{getGamma,DPParamsGam-method}
\alias{setGamma<-,DPParamsGam-method}
\alias{toGamma,DPParamsGam,numeric-method}
\title{An S4 class for random differential privacy parameters.}
\usage{
\S4method{show}{DPParamsGam}(object)

\S4method{getGamma}{DPParamsGam}(object)

\S4method{setGamma}{DPParamsGam}(object) <- value

\S4method{toGamma}{DPParamsGam,numeric}(object, gamma)
}
\arguments{
\item{object}{an object of class \code{\link{DPParamsGam}}.}

\item{value}{a scalar numeric \eqn{\gamma}.}

\item{gamma}{scalar numeric \eqn{\gamma}.}
}
\description{
An S4 base class representing the privacy parameters in
\eqn{(\epsilon,\delta,\gamma)}-random differential privacy.
}
\section{Methods (by generic)}{
\itemize{
\item \code{show}: automatically prints the object.

\item \code{getGamma}: getter for slot \code{gamma}.

\item \code{setGamma<-}: setter for slot \code{gamma}.

\item \code{toGamma}: returns object with set gamma; generic for use with
superclasses \code{\link{DPParamsEps}} and \code{\link{DPParamsDel}}.
}}

\section{Slots}{

\describe{
\item{\code{epsilon}}{positive scalar numeric privacy level.}

\item{\code{delta}}{a scalar numeric privacy level in interval [0,1).}

\item{\code{gamma}}{a scalar numeric privacy level in [0, 1).}
}}

\seealso{
\code{\link{DPParamsEps}}, \code{\link{DPParamsDel}} superclasses.
}
