% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exponential_mechanism.R
\docType{class}
\name{DPMechExponential-class}
\alias{DPMechExponential-class}
\alias{DPMechExponential}
\alias{show,DPMechExponential-method}
\alias{releaseResponse,DPMechExponential,DPParamsEps-method}
\alias{sensitivityNorm,DPMechExponential-method}
\title{An S4 class for the exponential mechanism of differential privacy.}
\usage{
\S4method{show}{DPMechExponential}(object)

\S4method{releaseResponse}{DPMechExponential,DPParamsEps}(mechanism,
  privacyParams, X)

\S4method{sensitivityNorm}{DPMechExponential}(mechanism, X1, X2)
}
\arguments{
\item{object}{an instance of class \code{DPMech}.}

\item{mechanism}{an object of class \code{\link{DPMechExponential}}.}

\item{privacyParams}{an object of class \code{\link{DPParamsEps}}.}

\item{X}{a privacy-sensitive dataset, if using sensitivity sampler a: list,
matrix, data frame, numeric/character vector.}

\item{X1}{a privacy-sensitive dataset.}

\item{X2}{a privacy-sensitive dataset.}
}
\value{
list with slots per argument, actual privacy parameter and response:
  mechanism response with length of target release:
  \code{privacyParams, sensitivity, responseSet, target, response}.

scalar numeric norm of non-private \code{target} on datasets.
}
\description{
A class that implements the exponential mechanism of differential privacy,
for privatizing releases from sets (not necessarily numeric as
required by \code{\link{DPMechLaplace}}). Currently limited to responses
from a finite sets - the most widely used case - as these induce easily
computed sampling distributions from a uniform base measure.
}
\section{Methods (by generic)}{
\itemize{
\item \code{show}: automatically prints the object.

\item \code{releaseResponse}: releases exponential mechanism responses.

\item \code{sensitivityNorm}: measures \code{target} quality score sensitivity.
}}

\section{Slots}{

\describe{
\item{\code{sensitivity}}{non-negative scalar numeric quality function sensitivity.
Defaults to \code{Inf} for use with \code{sensitivitySampler()}.}

\item{\code{target}}{the quality score function mapping dataset to a function on
responses (elements of \code{responseSet}).}

\item{\code{gammaSensitivity}}{\code{NA_real_} if inactive, or scalar in [0,1)
indicating that responses must be RDP with specific confidence.}

\item{\code{responseSet}}{a list of possible responses of the mechanism.}
}}

\examples{
## Sensitive data are strings of length at most 5.
## Task is to release most frequent character present, hence quality function
## is a closure that counts character frequencies for given candidate char.
## Global sensitivity is max string length.
qualF <- function(X) { function(r) sum(r == unlist(strsplit(X, ""))) }
rs <- as.list(letters)
m <- DPMechExponential(sensitivity = 5, target = qualF, responseSet = rs)
X <- strsplit("the quick brown fox jumps over the lazy dog"," ")[[1]]
p <- DPParamsEps(epsilon = 1)
releaseResponse(m, p, X)
}
\references{
Frank McSherry and Kunal Talwar. "Mechanism design via differential privacy."
  In the 48th Annual IEEE Symposium on Foundations of Computer Science
  (FOCS'07), pp. 94-103. IEEE, 2007.
}
