% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxplots.R
\name{boxplot_epoch}
\alias{boxplot_epoch}
\title{Plot interactive boxplots of epochs}
\usage{
boxplot_epoch(
  data,
  amplitude = "signal",
  subject,
  channel,
  time_lim,
  use_latex = TRUE
)
}
\arguments{
\item{data}{A data frame or a database table with EEG dataset. Required columns: subject, sensor, epoch, time and the column with EEG amplitude named as in \code{amplitude} parameter.}

\item{amplitude}{A character specifying the name of the column from input data with an EEG amplitude values. Default is \code{"signal"}.}

\item{subject}{An integer or character ID of selected subject to plot.}

\item{channel}{An integer or character ID of channel to plot.}

\item{time_lim}{A numeric vector with time range to plot.}

\item{use_latex}{A logical value indicating whether to use LaTeX formatting for the y-axis title. The default is \code{TRUE}.}
}
\value{
A \code{plotly} object with boxplots of EEG amplitude for individual epochs.
}
\description{
Function for plotting interactive boxplots of EEG amplitude in individual epochs for selected subject and channel within the chosen time interval. The interactive \code{plotly} output enables to easily determine the epoch number from which outliers come and also allows to easily edit the image layout.
}
\details{
The input data frame or database table must contain at least following columns:
subject - a column with subject IDs,
sensor - a column with sensor labels,
epoch - a column with epoch numbers,
time - a column with time point numbers,
and a column with measured EEG signal values (or their averages) called as in \code{amplitude}.
}
\examples{
# Interactive boxplots of signal from channel E34 for subject 1 (health control)
# in chosen time points
boxplot_epoch(epochdata, amplitude = "signal", subject = 1, channel = "E34",
 time_lim = c(10:20))

}
