% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_xor.R
\name{detect_xor}
\alias{detect_xor}
\title{Detect XOR Patterns in Variable Pairs}
\description{
Identifies XOR-shaped relationships between variables using statistical tests and pattern detection.
}
\usage{
detect_xor(
  data,
  class_col = "class",
  check_tau = TRUE,
  compute_axes_parallel_significance = TRUE,
  p_threshold = 0.05,
  tau_threshold = 0.3,
  abs_diff_threshold = 20,
  split_method = "quantile",
  max_cores = 1,
  extreme_handling = "winsorize",
  winsor_limits = c(0.05, 0.95),
  scale_data = TRUE,
  use_complete = TRUE
)
}
\arguments{
  \item{data}{Data frame containing features and class column}
  \item{class_col}{Name of class column (default: "class")}
  \item{check_tau}{Logical - compute classwise tau coefficients (default: TRUE)}
  \item{compute_axes_parallel_significance}{Logical - compute Wilcoxon tests (default: TRUE)}
  \item{p_threshold}{Significance threshold (default: 0.05)}
  \item{tau_threshold}{Tau coefficient threshold (default: 0.3)}
  \item{abs_diff_threshold}{Absolute difference threshold for patterns (default: 20)}
  \item{split_method}{Method for splitting data ("quantile" or "range") (default: "quantile")}
  \item{max_cores}{Maximum cores for parallel processing (default: NULL = automatic)}
  \item{extreme_handling}{Method for handling extreme values; options include "winsorize" or "none" (default: "winsorize")}
  \item{winsor_limits}{Numeric vector of length 2 specifying lower and upper quantiles for winsorization (default: c(0.05, 0.95))}
  \item{scale_data}{Logical; whether to scale/standardize the data before analysis (default: TRUE)}
  \item{use_complete}{Logical; whether to use only complete cases (default: TRUE)}
}
\value{
List containing:
  \item{results_df}{Data frame with detection results for all variable pairs}
  \item{pair_list}{Detailed analysis results for each variable pair}
}
\details{
This function performs an analysis to detect XOR-like patterns in pairwise variable relationships within two-class data sets. The analysis pipeline includes:

\enumerate{
  \item Data preprocessing (winsorization, scaling, complete cases)
  \item Tile pattern analysis using chi-squared tests
  \item Classwise Kendall tau correlation analysis
  \item Group-wise Wilcoxon significance tests
}

The function automatically handles parallel processing when multiple cores are available and returns both a summary data frame and detailed results for further analysis.
}
\examples{
\donttest{
# Load example data
data(XOR_data)

# Run XOR detection
results <- detect_xor(data = XOR_data, class_col = "class")

# View summary of detected patterns
print(results$results_df["xor_shape_detected"])

# Generate visualizations
spaghetti_plot <- generate_spaghetti_plot_from_results(
  results = results,
  data = XOR_data,
  class_col = "class"
)

print(spaghetti_plot)

xy_plot <- generate_xy_plot_from_results(
  results = results,
  data = XOR_data,
  class_col = "class"
)

print(xy_plot)

# Generate console report (doesn't write files)
generate_xor_reportConsole(results, XOR_data, "class", show_plots = FALSE)

# View detailed results for detected pairs
detected_pairs <- results$results_df[results$results_df$xor_shape_detected == TRUE, ]
print(detected_pairs)

}
}
\seealso{
\code{\link{generate_spaghetti_plot_from_results}} for spaghetti plot visualization, \code{\link{generate_xy_plot_from_results}} for scatter plot visualization, \code{\link{generate_xor_reportConsole}} for console reporting, \code{\link{generate_xor_reportHTML}} for HTML report generation, \code{\link{XOR_data}} for example dataset
}
\keyword{XOR}
\keyword{pattern}
\keyword{detection}