% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Stats.R
\name{summaryRuns}
\alias{summaryRuns}
\title{Summary statistics on detected runs}
\usage{
summaryRuns(runs, mapFile, genotypeFile, Class = 2, snpInRuns = FALSE)
}
\arguments{
\item{runs}{R object (dataframe) with results on detected runs}

\item{mapFile}{Plink map file (for SNP position)}

\item{genotypeFile}{Plink ped file (for SNP position)}

\item{Class}{group of length (in Mbps) by class (default: 0-2, 2-4, 4-8, 8-16, >16)}

\item{snpInRuns}{TRUE/FALSE (default): should the function \code{snpInsideRuns} be
called to compute the proportion of times each SNP falls inside a run in the
group/population?}
}
\value{
A list of dataframes containing the most relevant descriptives
statistics on detected runs. The list conveniently contains 9 dataframes that can
be used for further processing and visualization, or can be written out to text files
}
\description{
This function processes the results from \code{slidingRUNS.run} and
\code{consecutiveRUNS.run} and produces a number of interesting descriptives
statistics on results.
}
\details{
\code{summaryRuns} calculates: i) the number of runs per chromosome and group/population;
ii) the percent distribution of runs per chromosome and group; iii) the number of
runs per size-class and group; iv) the percent distribution of runs per size-class
and group; v) the mean length of runs per chromosome and group; vi) the mean
length of runs per size-class and group; vii) individual inbreeding coefficient
estimated from ROH; viii) individual inbreeding coefficient estimated from ROH
per chromosome; ix) individual inbreeding coefficient estimated from ROH per
size-class
}
\examples{
# getting map and ped paths
genotypeFile <- system.file("extdata", "Kijas2016_Sheep_subset.ped", package = "detectRUNS")
mapFile <- system.file("extdata", "Kijas2016_Sheep_subset.map", package = "detectRUNS")

# calculating runs of Homozygosity
\dontrun{
# skipping runs calculation
runs <- slidingRUNS.run(genotypeFile, mapFile, windowSize = 15, threshold = 0.1,  minSNP = 15,
ROHet = FALSE,  maxOppositeGenotype = 1, maxMiss = 1,  minLengthBps = 100000,  minDensity = 1/10000)
}
# loading pre-calculated data
runsFile <- system.file("extdata", "Kijas2016_Sheep_subset.sliding.csv", package="detectRUNS")
runsDF <- readExternalRuns(inputFile = runsFile, program = 'detectRUNS')

summaryRuns(runs = runsDF, mapFile = mapFile, genotypeFile = genotypeFile, Class = 2,
snpInRuns = FALSE)

}
