% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funktionen.R
\name{slidingRuns}
\alias{slidingRuns}
\title{Function to detect runs using sliding window approach}
\usage{
slidingRuns(indGeno, individual, mapFile, gaps, parameters, cpp = TRUE)
}
\arguments{
\item{indGeno}{vector of 0/1/NAs of individual genotypes (0: homozygote; 1: heterozygote)}

\item{individual}{list of group (breed, population, case/control etc.) and ID of individual sample}

\item{mapFile}{Plink map file (for SNP position)}

\item{gaps}{distance between SNPs}

\item{parameters}{list of parameters}

\item{cpp}{use cpp functions or not (DEBUG)}
}
\value{
A data frame of runs per individual sample
}
\description{
This is a core function not intended to be exported
}
\details{
This method uses sliding windows to detect RUNs. Checks on minimum n. of SNP, max n. of opposite and missing genotypes,
max gap between adjacent loci and minimum length of the run are implemented (as in the sliding window method).
Both runs of homozygosity (RoHom) and of heterozygosity (RoHet) can be search for (option ROHet: TRUE/FALSE)
NOTE: this methods is intended to not be exported
}
\keyword{internal}
