% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ABdesign.R
\name{ABdesign}
\alias{ABdesign}
\title{Sample size determination for A + B escalation design without dose de-escalation}
\usage{
ABdesign(A, B, C, D, E, prop=c())
}
\arguments{
\item{A}{Number patients at the dose level i}

\item{B}{Number of patients add at the dose level i when more than D number of patients have DLT}

\item{C}{Predetermined number patients out of A.}

\item{D}{Predetermined number patients out of A and D>=C}

\item{E}{Predetermined number patients out of A+B and E>=D}

\item{prop}{Vector of DLT rates at different dose level}
}
\value{
The expected number of patients at dose levels
}
\description{
Determination of sample size for each dose level using A + B escalation design without dose de-escalation
}
\details{
Let there are "A" patients at the dose level "i" and also consider "C" and "D" as
predetermined value where (D >= C).

If less than C patients have DLTs out of A patints then we escalate the dose at
(i+1)th level and if more than D have the DLT's out of A then we consider the
previous dose level (i-1)th as MTD(maximum dose level with toxicity rates occurring
no more than a predetermined value).

If more than C and less than D
patients have DLTs then we add B more patients at the ith dose level and then if more than E (E >= D) out
of (A+B) patients have the DLTs then we consider the previous dose level as MTD.

Now we are going to determine the expected number of sample size at the jth dose level.

# prop = Vector of DLT rates at different dose level

# n = Total number of doses

# N = Vector of expected number of patients at different level of doses
}
\examples{

# This is A+B escalation design without dose de-escalation. Here A=3 , B=3 indicates the
# number of patients at the  dose level i and taking C=D=E=1 the predetermined number of
# patients with DLT. Prop indicates the vector of the DLT rates at different dose level.

ABdesign(A = 3,B = 3,C = 1,D = 1,E = 1,prop= c(0.01,0.014,0.025,0.056,0.177,0.594,0.963))

}
\seealso{
crt.match crt.unmatch phsize precsize
}
\author{
Atanu Bhattacharjee, Rajashree Dey ,Soutik Halder and Akash Pawar
}
