% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_app.R
\name{designApp}
\alias{designApp}
\title{Run the Shiny Application}
\usage{
designApp(
  onStart = NULL,
  options = list(),
  enableBookmarking = "url",
  uiPattern = "/",
  ...
)
}
\arguments{
\item{onStart}{A function that will be called before the app is actually run.
This is only needed for \code{shinyAppObj}, since in the \code{shinyAppDir}
case, a \code{global.R} file can be used for this purpose.}

\item{options}{Named options that should be passed to the \code{runApp} call
(these can be any of the following: "port", "launch.browser", "host", "quiet",
"display.mode" and "test.mode"). You can also specify \code{width} and
\code{height} parameters which provide a hint to the embedding environment
about the ideal height/width for the app.}

\item{enableBookmarking}{Can be one of \code{"url"}, \code{"server"}, or
\code{"disable"}. The default value, \code{NULL}, will respect the setting from
any previous calls to  \code{\link[shiny:enableBookmarking]{enableBookmarking()}}. See \code{\link[shiny:enableBookmarking]{enableBookmarking()}}
for more information on bookmarking your app.}

\item{uiPattern}{A regular expression that will be applied to each \code{GET}
request to determine whether the \code{ui} should be used to handle the
request. Note that the entire request path must match the regular
expression in order for the match to be considered successful.}

\item{...}{arguments to pass to \code{golem_opts}. See \code{\link[golem]{get_golem_options}} for more details.}
}
\value{
This function does not return a value; interrupt R to stop the application (usually by pressing Ctrl+C or Esc).
}
\description{
Runs the designer Shiny application.

For more information about how the application works, either run the "Help" guide in-app, or run
\code{vignette("designer")}.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
designApp()
\dontshow{\}) # examplesIf}
}
