% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{order_poly}
\alias{order_poly}
\alias{order_poly<-}
\alias{season}
\alias{season<-}
\alias{kernel_fun}
\alias{kernel_fun<-}
\alias{bwidth}
\alias{bwidth<-}
\alias{boundary_method}
\alias{boundary_method<-}
\title{Smoothing Option Generics}
\usage{
order_poly(object)

order_poly(object) <- value

season(object, ...)

season(object) <- value

kernel_fun(object)

kernel_fun(object) <- value

bwidth(object)

bwidth(object) <- value

boundary_method(object)

boundary_method(object) <- value
}
\arguments{
\item{object}{an object from which to either retrieve options or in which to set 
an option.}

\item{value}{the value to set the corresponding option to.}

\item{...}{without use; implemented for possible future compatibility only.}
}
\value{
These generics do not return anything and are just the basis for more 
sophisticated methods.
}
\description{
Various generics that can be used write methods to either retrieve or set 
smoothing options.
}
\details{
\code{order_poly}, \code{season}, \code{kernel_fun}, \code{bwidth}, and
\code{boundary_method} can be used to retrieve the order of polynomial,
the seasonal frequency, the kernel function setting, the bandwidth and
the boundary method from an object with smoothing options. The corresponding
generics beginning with \code{<-} are useful to set such options instead.

The generics themselves are without a direct purpose.

Generics that can be extended by methods to set or obtain settings (e.g.
smoothing options) in certain objects.
}
