\name{agg.wtd.quantile}
\alias{agg.wtd.quantile}

\title{
Aggregated Weighted Quantile
}

\description{
Splits the data into subsets (according to the levels of a factor) and computes a weighted quantile for each
}

\usage{
agg.wtd.quantile(x, by, weights = NULL, prob = 0.5, na.rm = FALSE)
}

\arguments{
  \item{x}{numeric vector or data frame of numeric vectors}
  \item{by}{factor used to split the data}  
  \item{weights}{numeric vector of weights. If NULL (default), uniform weights (i.e. all equal to 1) are used.}
  \item{prob}{a value between 0 and 1. Default is 0.5 (median)} 
  \item{na.rm}{logical, indicating whether NA values should be silently removed before the computation proceeds. Default is FALSE.}
}

\value{
a data frame
}

\author{
Nicolas Robette
}

\seealso{
\code{\link{agg.wtd.mad}}
}

\examples{
data(Movies)
agg.wtd.quantile(Movies[,c("Critics", "BoxOffice")], by = Movies$Country)
}

\keyword{ multivariate }
\keyword{ misc }
