% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KLIEP.R
\name{KLIEP}
\alias{KLIEP}
\title{Estimate Density Ratio p(x)/q(x) by KLIEP (Kullback-Leibler Importance Estimation Procedure)}
\usage{
KLIEP(x1, x2, sigma = "auto", kernel_num = 100, fold = 5,
  verbose = TRUE)
}
\arguments{
\item{x1}{numeric vector or matrix. Data from a numerator distribution p(x).}

\item{x2}{numeric vector or matrix. Data from a denominator distribution q(x).}

\item{sigma}{positive numeric vector. Search range of Gaussian kernel bandwidth.}

\item{kernel_num}{positive integer. Number of kernels.}

\item{fold}{positive integer. Number of the folds of cross validation.}

\item{verbose}{logical (default TRUE).}
}
\value{
KLIEP object that contains a function to compute estimated density ratio.
}
\description{
Estimate Density Ratio p(x)/q(x) by KLIEP (Kullback-Leibler Importance Estimation Procedure)
}
