% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trim.R
\name{dptrim_s}
\alias{dptrim_s}
\title{Automatically trim an individual density profile on the starting side}
\usage{
dptrim_s(dp, return.plot = FALSE, return.fail = FALSE, silent = FALSE, ...)
}
\arguments{
\item{dp}{An dp object, see \code{dpload}}

\item{return.plot}{Return a plot instead of dp object? If TRUE,
returns a plot instead of a dp object. When return.fail = TRUE,
it returns a list of three: dp object, start trimming success
and end trimming success.}

\item{return.fail}{Should information on the success of trimming be
included when returning a dp object?}

\item{silent}{Mute detection warnings, used when calling on list. A
list of trimmed dp objects, a result of calling dptriml or
dptriml_s on a dp list with rreport = FALSE.}

\item{...}{Parameters minseglen, span and nroll, will get passed through
to dpdetect_s, adjust when profile resolution is not 1/100 of a millimeter.}
}
\value{
A trimmed dp object, with the beginning and ending
  removed, if they were detected. When return.plot = TRUE, it
  returns a plot displaying the process.
}
\description{
Calls dpdetect_s on a given dpa object and returns a trimmed
dpa object with the the rows before the starting point removed. If
return.plot = TRUE, it will return a plot displaying the dp object
with detected starting point. If called with the option
return.fail = FALSE and return.plot = FALSE, the returned
object will also include information on whether starting cutoff
point was detected. If starting point not detected, dp object is
returned with no changes. When running on a list of dp objects,
use \code{dtriml_s}.
}
\examples{
\donttest{
## load a single file
dp <- dpload(system.file("extdata", "00010001.dpa", package = "densitr"))
## trim the measurement at start
dp.trimmed <- dptrim_s(dp)
## plot trimming
dptrim_s(dp, return.plot = TRUE)
}
}
\seealso{
dptrim, dptriml, dptriml_s
}
