% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deltatest.R
\name{deltatest}
\alias{deltatest}
\title{Two Sample Z-Test for Ratio Metrics Using the Delta Method}
\usage{
deltatest(
  data,
  formula,
  by,
  group_names = "auto",
  type = c("difference", "relative_change"),
  bias_correction = FALSE,
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95,
  na.rm = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{data}{data.frame containing the numerator and denominator columns of
the ratio metric, aggregated by randomization unit. It also includes a
column indicating the assigned group (control or treatment). For example,
if randomizing by user while the metric is click-through rate (CTR) per
page-view, the numerator is the number of clicks per user, and the
denominator is the number of page views per user.}

\item{formula}{expression representing the ratio metric. It can be written in
three styles: standard formula \code{x/y ~ group}, lambda formula \code{~ x/y}, or
NSE expression \code{x/y}.}

\item{by}{character string or symbol that indicates the group column. If the
group column is specified in the \code{formula} argument, it is not required.}

\item{group_names}{character vector of length 2 or \code{"auto"}. It specifies
which of the two strings contained in the group column is the control group
and which is the treatment group. The first string is considered the control
group, and the second string is considered the treatment group. If \code{"auto"}
is specified, it is interpreted as specifying the strings in the group
column sorted in lexicographical order. The default is \code{"auto"}.}

\item{type}{character string specifying the test type. If \code{"difference"}
(default), the hypothesis test evaluates the difference in means of the
ratio metric between two groups. If \code{"relative_change"}, it evaluates the
relative change \eqn{(\mu_2 - \mu_1) / \mu_1} instead. You can specify just
the initial letter.}

\item{bias_correction}{logical value indicating whether correction to the
mean of the metric is performed using the second-order term of the Taylor
expansion. The default is \code{FALSE}.}

\item{alternative}{character string specifying the alternative hypothesis,
must be one of \code{"two.sided"} (default), \code{"greater"}, or \code{"less"}. You can
specify just the initial letter.}

\item{conf.level}{numeric value specifying the confidence level of the
interval. The default is 0.95.}

\item{na.rm}{logical value. If \code{TRUE}, rows containing NA values in the data
will be excluded from the analysis. The default is \code{FALSE}.}

\item{quiet}{logical value indicating whether messages should be displayed
during the execution of the function. The default is \code{FALSE}.}
}
\value{
A list with class \code{"htest"} containing following components:
\item{statistic}{the value of the Z-statistic.}
\item{p.value}{the p-value for the test.}
\item{conf.int}{a confidence interval for the difference or relative change
appropriate to the specified alternative hypothesis.}
\item{estimate}{the estimated means of the two groups, and the difference
or relative change.}
\item{null.value}{the hypothesized value of the difference or relative
change in means under the null hypothesis.}
\item{stderr}{the standard error of the difference or relative change.}
\item{alternative}{a character string describing the alternative hypothesis.}
\item{method}{a character string describing the method used.}
\item{data.name}{the name of the data.}
}
\description{
Performs two sample Z-test to compare the ratio metrics between two groups
using the delta method. The Delta method is used to estimate the variance by
accounting for the correlation between the numerator and denominator of ratio
metrics.
}
\examples{
library(dplyr)
library(deltatest)

n_user <- 2000

set.seed(314)
df <- deltatest::generate_dummy_data(n_user) |>
  group_by(user_id, group) |>
  summarise(click = sum(metric), pageview = n(), .groups = "drop")

deltatest(df, click / pageview, by = group)

}
\references{
\itemize{
\item Deng, A., Knoblich, U., & Lu, J. (2018). Applying the Delta
Method in Metric Analytics: A Practical Guide with Novel Ideas.
\emph{Proceedings of the 24th ACM SIGKDD International Conference on Knowledge
Discovery & Data Mining.} \doi{10.1145/3219819.3219919}
}
}
