% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_delim_cols.R
\name{get_delim_cols}
\alias{get_delim_cols}
\title{Extract Labels and Colors from Species Delimitation Partitions}
\usage{
get_delim_cols(p, delimname = NULL, hap_tbl = NULL)
}
\arguments{
\item{p}{Output from \link{delim_autoplot}.}

\item{delimname}{A character vector of species delimitation names (optional).
If provided, the function filters the data to only include rows matching such terms. Default to NULL.}

\item{hap_tbl}{output from \link{haplotype_tbl} (optional).
If provided, the function will annotate color and fill data for collapsed haplotypes. Default to NULL.}
}
\value{
an object of class \link[tibble:tbl_df-class]{tbl_df}.
}
\description{
\code{get_delim_cols()} returns a \link[tibble:tbl_df-class]{tbl_df} format containing
extracted and processed data from \link{delim_autoplot}.
}
\details{
\code{get_delim_cols()} is a convenience function to extract labels, species partitions,
color and fill data from the output of \link{delim_autoplot} in a \link[tibble:tbl_df-class]{tbl_df}
format. It is best used when combined with haplotype information from
\link{haplotype_tbl} or when combined with other metadata, such as GPS coordinates
for map plotting.
}
\examples{

# plot using autoplot
p <- delim_autoplot(geophagus_delims, geophagus_beast)

# view 
p

# get haplotypes
hap_tbl <- haplotype_tbl(geophagus)

# extract colors for consensus
get_delim_cols(p, delimname= "consensus", hap_tbl= hap_tbl)


}
\author{
Pedro S. Bittencourt.
}
